/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.auth.interceptor;

import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.sanyuan.SanYuanMsgFormatter;
import com.testor.biz.sys.sanyuan.SanYuanOriginalDataHelper;
import com.testor.biz.sys.sanyuan.SanYuanReqEnum;
import com.testor.biz.sys.sanyuan.SanYuanStatusEnum;
import com.testor.biz.sys.sanyuan.model.domain.SysSanyuan;
import com.testor.biz.sys.sanyuan.service.SysSanyuanService;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.jwt.JwtHelper;
import com.tongtech.tfw.backend.common.models.jwt.JwtInfos;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.common.request.RequestUtil;
import com.tongtech.tfw.backend.common.response.ResponseUtil;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;

public class SanyuInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SanyuInterceptor.class);
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private SysSanyuanService sysSanyuanService;
    @Value(value="${auth.sanyuan}")
    private boolean sanyuan;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object obj) {
        if (!this.sanyuan) {
            return true;
        }
        HttpServletRequest httpRequest = request;
        HttpServletResponse httpResponse = response;
        String contentPath = request.getContextPath();
        String requestMethod = (String)httpRequest.getAttribute("method");
        String requestUri = StringHelper.removePrefix((CharSequence)((String)httpRequest.getAttribute("url")), (CharSequence)contentPath);
        SanYuanReqEnum sanYuanReqEnum = Arrays.stream(SanYuanReqEnum.values()).filter(enums -> enums.url().trim().toLowerCase().equals(requestUri.trim().toLowerCase())).findAny().orElse(null);
        if (ObjectHelper.isEmpty((Object)((Object)sanYuanReqEnum))) {
            return true;
        }
        String userId = null;
        try {
            userId = ContextUtils.getLoginUserId();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e0d\u5230\u767b\u5f55\u7528\u6237\u4fe1\u606f");
            return false;
        }
        if (StringHelper.isBlank((CharSequence)userId)) {
            String token = RequestUtil.getToken((HttpServletRequest)httpRequest);
            try {
                JwtInfos jwtInfos = JwtHelper.parseJwtAuth0((String)token, (String)"Token Issuer");
                userId = jwtInfos.getUserId();
            }
            catch (ExpiredJwtException eje) {
                this.sendExpiredJwt((ServletRequest)request, (ServletResponse)response);
                return false;
            }
        }
        if (StringHelper.isBlank((CharSequence)userId)) {
            this.sendUnexpectUser((ServletRequest)request, (ServletResponse)response);
            return false;
        }
        SysUser sysUser = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)userId)));
        if ("8".equals(sysUser.getUserType())) {
            return true;
        }
        SuperModel sysSanyuan = ((SysSanyuan.SysSanyuanBuilder)((SysSanyuan.SysSanyuanBuilder)((SysSanyuan.SysSanyuanBuilder)((SysSanyuan.SysSanyuanBuilder)((Object)((SysSanyuan.SysSanyuanBuilder)((Object)((SysSanyuan.SysSanyuanBuilder)((Object)((SysSanyuan.SysSanyuanBuilder)((Object)((SysSanyuan.SysSanyuanBuilder)((Object)((SysSanyuan.SysSanyuanBuilder)((Object)((SysSanyuan.SysSanyuanBuilder)((Object)((SysSanyuan.SysSanyuanBuilder)((Object)((SysSanyuan.SysSanyuanBuilder)((Object)SysSanyuan.builder().syId(IdHelper.getId32bit()))).syOp(sanYuanReqEnum.op()))).syOpType(sanYuanReqEnum.type()))).syOpUrl(sanYuanReqEnum.url()))).syOpMethod(requestMethod))).syOpData(RequestUtil.getRequestBody((HttpServletRequest)httpRequest)))).syOpApplier(sysUser.getUserName()))).syOpApplyDate(LocalDateTime.now()))).syOpApplyOrg(this.sysOrgService.getOrgFullPathName(sysUser.getOrgId())))).syOpAuditState("0").status("0")).createBy(sysUser.getUserId())).createDate(LocalDateTime.now())).build();
        sysSanyuan.setSyOpMsg(SanYuanMsgFormatter.msgFormatter((SysSanyuan)sysSanyuan));
        sysSanyuan.setSyOpOriginId(SanYuanOriginalDataHelper.getOriginalDataId((SysSanyuan)sysSanyuan));
        this.sysSanyuanService.save(sysSanyuan);
        this.sendHandleSanyuan((ServletRequest)request, (ServletResponse)response);
        return false;
    }

    private void sendExpiredJwt(ServletRequest request, ServletResponse response) {
        ResponseUtil.response((HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response), (ResponseInfo)BaseStatusEnum.TOKEN_INVALID.transform(), null);
    }

    private void sendUnexpectUser(ServletRequest request, ServletResponse response) {
        ResponseUtil.response((HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response), (ResponseInfo)SanYuanStatusEnum.UNEXPECTED_USER.transform(), null);
    }

    private void sendHandleSanyuan(ServletRequest request, ServletResponse response) {
        ResponseUtil.response((HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response), (ResponseInfo)SanYuanStatusEnum.SUBMITTED.transform(), null);
    }
}

