/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.excel.controller;

import com.testor.biz.excel.ExcelConstants;
import com.testor.biz.excel.ExcelEnum;
import com.testor.biz.excel.model.ColsDto;
import com.testor.biz.excel.support.ExcelDtoHelper;
import com.testor.biz.helper.CommonHelper;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.context.ContextHelper;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.constants.IoConstants;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.datetime.DatetimeHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="Excel Controller", tags={"Excel \u516c\u5171\u63a5\u53e3"})
@RequestMapping(value={"/excel"})
public class ExcelController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(ExcelController.class);

    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u5217", notes="\u83b7\u53d6\u5bfc\u51fa\u5217 Get Excel Columns by bean name")
    @GetMapping(value={"/getColumns"})
    public BaseResponse<List<ColsDto>> getExcelCol(String beanName) {
        BaseResponse result = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)beanName)) {
            Object bean = ContextHelper.getBeanByName((String)beanName);
            if (ObjectHelper.isEmpty((Object)bean)) {
                throw new ApiException(ExcelEnum.NOT_FOUND.transform());
            }
            List<ColsDto> colMap = ExcelDtoHelper.getCols(bean);
            result.setData(colMap);
        }
        return result;
    }

    @ApiOperation(value="\u6839\u636e\u540d\u79f0\u4e0b\u8f7d\u6a21\u677f", notes="\u6839\u636e\u540d\u79f0\u4e0b\u8f7d\u6a21\u677f download export template with name")
    @GetMapping(value={"/downloadImportTemplate"})
    public void download(String fileName, HttpServletResponse res) throws IOException {
        Pattern p = Pattern.compile("^[\\u4e00-\\u9fa5-a-zA-Z0-9]+\\.xlsx$");
        if (!p.matcher(fileName).matches()) {
            res.sendError(404);
            return;
        }
        CommonHelper.fileDownload(fileName, new File("excel").getAbsolutePath() + IoConstants.PATH_SLASH + fileName, res);
    }

    @ApiOperation(value="\u6839\u636e\u540d\u79f0\u4e0b\u8f7d\u9519\u8bef\u6570\u636e\u6a21\u677f", notes="\u6839\u636e\u540d\u79f0\u4e0b\u8f7d\u9519\u8bef\u6570\u636e\u6a21\u677f\uff0cdownload error data with name")
    @GetMapping(value={"/downloadImportErrorHistory"})
    public void downloadError(String fileName, HttpServletResponse res) throws IOException {
        Pattern p = Pattern.compile("^[\\u4e00-\\u9fa5-a-zA-Z0-9]+\\.xlsx$");
        if (!p.matcher(fileName).matches()) {
            res.sendError(404);
            return;
        }
        String displayName = DatetimeHelper.getDateTime8Length() + "-\u6570\u636e\u5bfc\u5165\u9519\u8bef\u8bb0\u5f55." + "xlsx";
        CommonHelper.fileDownload(displayName, new File("excel").getAbsolutePath() + ExcelConstants.PATH_SLASH + "history" + IoConstants.PATH_SLASH + fileName, res);
    }
}

