/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.org.controller;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.excel.ExcelEnum;
import com.testor.biz.excel.model.ImportError;
import com.testor.biz.excel.service.ExcelService;
import com.testor.biz.excel.service.TongExcelListener;
import com.testor.biz.excel.support.ExcelDtoHelper;
import com.testor.biz.sys.org.OrgEnumCode;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.model.dto.DeptAndPost;
import com.testor.biz.sys.org.model.dto.OrgImport;
import com.testor.biz.sys.org.model.dto.OrgImportResponse;
import com.testor.biz.sys.org.model.dto.ReturnOrg;
import com.testor.biz.sys.org.model.dto.SysOrgCreateAndUpdateRequest;
import com.testor.biz.sys.org.model.dto.SysOrgDelRequest;
import com.testor.biz.sys.org.model.dto.SysOrgParam;
import com.testor.biz.sys.org.model.dto.TreeVO;
import com.testor.biz.sys.org.service.OrgExcelImport;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.post.model.domain.TSysPost;
import com.testor.biz.sys.post.model.dto.TSysPostParam;
import com.testor.biz.sys.post.service.TSysPostService;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(value="SysOrg", tags={"SysOrg \u7ec4\u7ec7\u673a\u6784"})
@RequestMapping(value={"/org"})
public class SysOrgController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysOrgController.class);
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private TSysPostService tSysPostService;
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private ExcelService excelService;
    @Autowired
    OrgExcelImport orgExcelImport;

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u673a\u6784", notes="")
    @GetMapping(value={"/getOrgList"})
    public BaseResponse<List<SysOrg>> getOrgList() throws Exception {
        BaseResponse baseResponse = new BaseResponse();
        List list = this.sysOrgService.list((Wrapper)((QueryWrapper)new QueryWrapper().ne((Object)"status", (Object)"1")).eq((Object)"is_dept", (Object)"0"));
        baseResponse.setData((Object)list);
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u8fd4\u56de\u5f53\u524d\u673a\u6784\u4e0b\u7684\u90e8\u95e8\u4fe1\u606f\u3011", notes="\u83b7\u53d6\u673a\u6784\u90e8\u95e8\u4fe1\u606f")
    @GetMapping(value={"/returnDept"})
    public BaseResponse<List<SysOrg>> returnDeptsss() {
        BaseResponse baseResponse = new BaseResponse();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        List list = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)orgId)).eq((Object)"is_dept", (Object)"1")).ne((Object)"status", (Object)"1"));
        baseResponse.setData((Object)list);
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u8fd4\u56de\u5f53\u524d\u767b\u5f55\u4f01\u4e1a\u7684\u90e8\u95e8\u4fe1\u606f\u53ca\u4eba\u5458\u3011", notes="")
    @GetMapping(value={"/returnDeptPerson"})
    public BaseResponse<ReturnOrg> returnDeptPersonss() {
        BaseResponse baseResponse = new BaseResponse();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        SysOrg one = (SysOrg)((Object)this.sysOrgService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId)).ne((Object)"status", (Object)"1")));
        ReturnOrg returnOrg = (ReturnOrg)((Object)BeanHelper.beanToBean((Object)((Object)one), ReturnOrg.class));
        List list = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)returnOrg.getOrgId())).eq((Object)"is_dept", (Object)"1")).ne((Object)"status", (Object)"1"));
        ArrayList<SysOrg> returnOrgs = new ArrayList<SysOrg>();
        for (SysOrg org : list) {
            ReturnOrg returnOrg1 = (ReturnOrg)((Object)BeanHelper.beanToBean((Object)((Object)org), ReturnOrg.class));
            List list1 = this.sysUserService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dept_id", (Object)returnOrg1.getOrgId())).ne((Object)"status", (Object)"1"));
            returnOrg1.setUsers(list1);
            returnOrgs.add(returnOrg1);
        }
        returnOrg.setOrgList(returnOrgs);
        baseResponse.setData((Object)returnOrg);
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u65b0\u589e\u673a\u6784\u4fe1\u606f\u53ca\u90e8\u95e8\u4fe1\u606f\u3011", notes="\u65b0\u589e\u673a\u6784\u4fe1\u606f\u53ca\u90e8\u95e8\u4fe1\u606f\uff0c \u5982\u679c\u65b0\u589e\u90e8\u95e8 isDept\u4f20 1 \u65b0\u589e\u673a\u6784\u4f20 0")
    @PostMapping(value={"/add"})
    public BaseResponse<SysOrg> addEntity(@Valid @RequestBody SysOrgCreateAndUpdateRequest addRequest) throws Exception {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)addRequest)) {
            throw new ApiException(OrgEnumCode.ORG_PARAM_IS_NULL.transform());
        }
        List sysOrgList = this.sysOrgService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_code", (Object)addRequest.getOrgCode())).ne((Object)"status", (Object)"1"));
        if (!ObjectHelper.isEmpty((Object)sysOrgList)) {
            throw new ApiException(OrgEnumCode.ORG_CODE_ALREADY_EXISTS.transform());
        }
        String parentId = addRequest.getParentId();
        if (!StringHelper.isEmpty((CharSequence)parentId) && !"0".equals(parentId)) {
            SysOrg parentOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)parentId)));
            addRequest.setParentIds(parentOrg.getParentIds() + "," + parentOrg.getOrgId());
        } else {
            addRequest.setParentId("0");
            addRequest.setParentIds("0");
        }
        List sysOrgs = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_name", (Object)addRequest.getOrgName())).eq((Object)"parent_id", (Object)addRequest.getParentId())).ne((Object)"status", (Object)"1"));
        if (!ObjectHelper.isEmpty((Object)sysOrgs)) {
            throw new ApiException(OrgEnumCode.ORG_NAME_ALREADY_EXISTS.transform());
        }
        SysOrg data = (SysOrg)((Object)BeanHelper.beanToBean((Object)addRequest, SysOrg.class));
        String bit = IdHelper.getId32bit();
        data.setOrgId(bit);
        boolean flag = this.sysOrgService.save((Object)data);
        if (flag) {
            if ("0".equals(addRequest.getIsDept())) {
                SysOrg sysOrg = new SysOrg();
                String parent = addRequest.getParentId();
                if (!StringHelper.isEmpty((CharSequence)parent) && !"0".equals(parent)) {
                    SysOrg parentOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)parent)));
                    sysOrg.setParentId(bit);
                    sysOrg.setParentIds(parentOrg.getParentIds() + "," + parentOrg.getOrgId() + "," + bit);
                } else {
                    sysOrg.setParentId("0");
                    sysOrg.setParentIds("0");
                }
                String dept = IdHelper.getId32bit();
                sysOrg.setOrgId(dept);
                sysOrg.setOrgName("\u5b89\u5168\u73af\u4fdd\u90e8");
                sysOrg.setIsDept("1");
                this.sysOrgService.save((Object)sysOrg);
                TSysPostParam tSysPostParam = new TSysPostParam();
                tSysPostParam.setDeptId(dept);
                ArrayList<TSysPost> posts = new ArrayList<TSysPost>();
                TSysPost tSysPost = new TSysPost();
                tSysPost.setPostName("\u5b89\u5168\u751f\u4ea7\u5c97");
                posts.add(tSysPost);
                tSysPostParam.setTSysPosts(posts);
                this.tSysPostService.addEntity(tSysPostParam);
            }
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539\u673a\u6784\u4fe1\u606f", notes="\u4fee\u6539\u673a\u6784\u4fe1\u606f Edit Org Info")
    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/update"})
    public BaseResponse<SysOrg> updateEntity(@Valid @RequestBody SysOrgCreateAndUpdateRequest updateRequest) {
        boolean flag;
        List<SysOrg> childrenOrgList;
        List sysOrgList;
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)updateRequest)) {
            throw new ApiException(OrgEnumCode.ORG_PARAM_IS_NULL.transform());
        }
        if (StringHelper.isEmpty((CharSequence)updateRequest.getOrgId())) {
            throw new ApiException(OrgEnumCode.ORG_ID_NOT_EXISTENT.transform());
        }
        SysOrg oldSysOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)updateRequest.getOrgId())));
        if (ObjectHelper.isEmpty((Object)((Object)oldSysOrg))) {
            throw new ApiException(OrgEnumCode.ORG_ID_NOT_EXISTENT.transform());
        }
        SysOrg modifyOrg = (SysOrg)((Object)BeanHelper.beanToBean((Object)updateRequest, SysOrg.class));
        if (!(StringHelper.isEmpty((CharSequence)updateRequest.getOrgCode()) || oldSysOrg.getOrgCode().equals(updateRequest.getOrgCode()) || ObjectHelper.isEmpty((Object)(sysOrgList = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_code", (Object)updateRequest.getOrgCode())).ne((Object)"org_id", (Object)updateRequest.getOrgId())).ne((Object)"status", (Object)"1")))))) {
            throw new ApiException(OrgEnumCode.ORG_CODE_ALREADY_EXISTS.transform());
        }
        boolean isStatusChanged = false;
        if (!modifyOrg.getStatus().equals(oldSysOrg.getStatus())) {
            isStatusChanged = true;
        }
        boolean isParentOrgChanged = false;
        String newParentId = modifyOrg.getParentId();
        if (StringHelper.isEmpty((CharSequence)newParentId)) {
            newParentId = "0";
        }
        String oldParentIds = oldSysOrg.getParentIds();
        String newParentIds = "0";
        if (!oldSysOrg.getParentId().equals(newParentId)) {
            isParentOrgChanged = true;
            if ("0".equals(newParentId)) {
                modifyOrg.setParentId("0");
                modifyOrg.setParentIds("0");
            } else {
                SysOrg tmp = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)newParentId)));
                if (ObjectHelper.isEmpty((Object)((Object)tmp))) {
                    throw new ApiException(OrgEnumCode.ORG_ID_NOT_EXISTENT.transform());
                }
                newParentIds = tmp.getParentIds() + "," + tmp.getOrgId();
                modifyOrg.setParentIds(newParentIds);
            }
        }
        if ((isStatusChanged || isParentOrgChanged) && !ObjectHelper.isEmpty(childrenOrgList = this.sysOrgService.getChildrenById(modifyOrg.getOrgId()))) {
            if (isParentOrgChanged) {
                String finalNewParentIds = newParentIds;
                childrenOrgList = childrenOrgList.stream().map(org -> org.setParentIds(org.getParentIds().replaceAll(oldParentIds, finalNewParentIds))).collect(Collectors.toList());
            }
            childrenOrgList = childrenOrgList.stream().peek(org -> org.setStatus(updateRequest.getStatus())).collect(Collectors.toList());
            this.sysOrgService.updateBatchById(childrenOrgList);
        }
        if (flag = this.sysOrgService.updateById((Object)modifyOrg)) {
            baseResponse.setData((Object)modifyOrg);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u4fee\u6539\u90e8\u95e8\u540d\u79f0\u3011", notes="")
    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/updateDeptName"})
    public BaseResponse<SysOrg> updateDept(@RequestBody SysOrgCreateAndUpdateRequest updateRequest) {
        List list;
        String orgId = ContextUtils.getLoginUser().getOrgId();
        SysOrg sysOrg = (SysOrg)((Object)BeanHelper.beanToBean((Object)updateRequest, SysOrg.class));
        SysOrg org = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)updateRequest.getOrgId())));
        if (!updateRequest.getOrgName().equals(org.getOrgName()) && ObjectHelper.isNotEmpty((Object)(list = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)orgId)).eq((Object)"is_dept", (Object)"1")).eq((Object)"org_name", (Object)updateRequest.getOrgName())).ne((Object)"status", (Object)"1"))))) {
            throw new ApiException(OrgEnumCode.ORG_NAME_ALREADY_EXISTS.transform());
        }
        this.sysOrgService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"org_id", (Object)sysOrg.getOrgId())).set((Object)"org_name", (Object)sysOrg.getOrgName()));
        BaseResponse sysOrgBaseResponse = new BaseResponse();
        sysOrgBaseResponse.setData((Object)sysOrg);
        return sysOrgBaseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u673a\u6784ID\u5220\u9664\u673a\u6784", notes="\u6839\u636e\u673a\u6784ID\u5220\u9664\u673a\u6784 Delete Org")
    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody SysOrgDelRequest sysOrgDelRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isEmpty((CharSequence)sysOrgDelRequest.getOrgId())) {
            throw new ApiException(OrgEnumCode.REQUIRED_ITEMS_MISSING.transform());
        }
        QueryWrapper userQueryWrapper = new QueryWrapper();
        List orgList = this.sysOrgService.getChildrenById(sysOrgDelRequest.getOrgId()).stream().map(SysOrg::getOrgId).collect(Collectors.toList());
        if (orgList.isEmpty()) {
            userQueryWrapper.eq((Object)"org_id", (Object)sysOrgDelRequest.getOrgId());
        } else {
            orgList.add(sysOrgDelRequest.getOrgId());
            userQueryWrapper.in((Object)"org_id", orgList);
        }
        userQueryWrapper.ne((Object)"status", (Object)"1");
        int userCounter = this.sysUserService.count((Wrapper)userQueryWrapper);
        if (userCounter > 0) {
            throw new ApiException(OrgEnumCode.ORG_USER_IS_NOT_NULL.transform());
        }
        SysOrg data = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)sysOrgDelRequest.getOrgId())));
        if (ObjectHelper.isEmpty((Object)((Object)data))) {
            throw new ApiException(OrgEnumCode.ORG_ID_NOT_EXISTENT.transform());
        }
        data.setStatus("1");
        List parentResourceList = this.sysOrgService.list((Wrapper)new QueryWrapper().lambda().like(SysOrg::getParentIds, (Object)data.getOrgId()));
        this.sysOrgService.updateBatchById(parentResourceList.stream().peek(org -> org.setStatus("1")).collect(Collectors.toList()));
        boolean result = this.sysOrgService.updateById((Object)data);
        List postList = this.tSysPostService.list((Wrapper)new QueryWrapper().lambda().like(TSysPost::getDeptId, (Object)data.getOrgId()));
        this.tSysPostService.updateBatchById(postList.stream().peek(org -> org.setStatus("1")).collect(Collectors.toList()));
        List personList = this.sysUserService.list((Wrapper)new QueryWrapper().lambda().like(SysUser::getDeptId, (Object)data.getOrgId()));
        this.sysUserService.updateBatchById(personList.stream().peek(org -> org.setStatus("1")).collect(Collectors.toList()));
        baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u5217\u8868 TREE-INFOs", notes="\u83b7\u53d6\u673a\u6784\u5217\u8868\u4fe1\u606f Get Orgs For Tree")
    @GetMapping(value={"/list"})
    public BaseResponse<List<SysOrg>> listEntity() {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setData((Object)this.sysOrgService.list((Wrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"org_id", "parent_id", "parent_ids", "tree_level", "tree_sort", "org_name", "org_code", "status"}).ne((Object)"status", (Object)"1")).orderBy(true, true, (Object[])new String[]{"tree_sort"})));
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u5217\u8868 ID+NAME", notes="\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u6811")
    @GetMapping(value={"/tree"})
    public BaseResponse<List<SysOrg>> treeEntity() {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setData((Object)this.sysOrgService.list((Wrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"org_id", "org_name"}).ne((Object)"status", (Object)"1")).orderBy(true, true, (Object[])new String[]{"tree_sort"})));
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u5217\u8868 SELF+SUB", notes="\u6839\u636e\u673a\u6784ID\u83b7\u53d6\u5176\u5b50\u673a\u6784")
    @GetMapping(value={"/children"})
    public BaseResponse<List<SysOrg>> childrenEntity(String orgId) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setData(this.sysOrgService.getChildrenById(orgId));
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237id\u83b7\u53d6\u5b50\u7ec4\u7ec7\u673a\u6784\u6811\u53ca\u5b50\u90e8\u95e8\u4fe1\u606f\u3011 ", notes="")
    @GetMapping(value={"/getOrgAndTree"})
    public BaseResponse<TreeVO> getOrgAndTree(String orgId) {
        BaseResponse baseResponse = new BaseResponse();
        List list = this.sysOrgService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId)).ne((Object)"status", (Object)"1"));
        TreeVO treeVO = null;
        for (SysOrg sysOrg : list) {
            treeVO = (TreeVO)BeanHelper.beanToBean((Object)((Object)sysOrg), TreeVO.class);
            List list1 = this.sysOrgService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)treeVO.getOrgId())).ne((Object)"status", (Object)"1"));
            ArrayList<TreeVO> treeVOS = new ArrayList<TreeVO>();
            for (SysOrg org : list1) {
                TreeVO treeVO1 = (TreeVO)BeanHelper.beanToBean((Object)((Object)org), TreeVO.class);
                List list2 = this.sysOrgService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)treeVO1.getOrgId())).ne((Object)"status", (Object)"1"));
                ArrayList<TreeVO> treeVOS1 = new ArrayList<TreeVO>();
                for (SysOrg sysOrg1 : list2) {
                    TreeVO treeVO2 = (TreeVO)BeanHelper.beanToBean((Object)((Object)sysOrg1), TreeVO.class);
                    treeVOS1.add(treeVO2);
                }
                treeVO1.setChildren(treeVOS1);
                treeVOS.add(treeVO1);
            }
            treeVO.setChildren(treeVOS);
        }
        baseResponse.setData(treeVO);
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237id\u83b7\u53d6\u5b50\u7ec4\u7ec7\u673a\u6784\u6811\u3011", notes="")
    @GetMapping(value={"/getOrgTree"})
    public BaseResponse<TreeVO> getOrgTree(String orgId) {
        BaseResponse baseResponse = new BaseResponse();
        List list = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId)).eq((Object)"is_dept", (Object)"0")).ne((Object)"status", (Object)"1"));
        TreeVO treeVO = null;
        for (SysOrg sysOrg : list) {
            treeVO = (TreeVO)BeanHelper.beanToBean((Object)((Object)sysOrg), TreeVO.class);
            List list1 = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)treeVO.getOrgId())).eq((Object)"is_dept", (Object)"0")).ne((Object)"status", (Object)"1"));
            ArrayList<TreeVO> treeVOS = new ArrayList<TreeVO>();
            for (SysOrg org : list1) {
                TreeVO treeVO1 = (TreeVO)BeanHelper.beanToBean((Object)((Object)org), TreeVO.class);
                List list2 = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)treeVO1.getOrgId())).eq((Object)"is_dept", (Object)"0")).ne((Object)"status", (Object)"1"));
                ArrayList<TreeVO> treeVOS1 = new ArrayList<TreeVO>();
                for (SysOrg sysOrg1 : list2) {
                    TreeVO treeVO2 = (TreeVO)BeanHelper.beanToBean((Object)((Object)sysOrg1), TreeVO.class);
                    treeVOS1.add(treeVO2);
                }
                if (treeVOS1.size() != 0) {
                    treeVO1.setChildren(treeVOS1);
                }
                treeVOS.add(treeVO1);
            }
            if (treeVOS.size() == 0) continue;
            treeVO.setChildren(treeVOS);
        }
        baseResponse.setData(treeVO);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u767b\u9646\u4eba\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u5217\u8868", notes="\u6839\u636e\u767b\u9646\u4eba\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/getOrgAllByLoginUser"})
    public BaseResponse<List<SysOrg>> getOrgAllByLoginUser() {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setData(this.sysOrgService.getOrgAllByLoginUser());
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u767b\u9646\u4eba\u83b7\u53d6\u5f53\u524d\u548c\u4e0b\u7ea7\u673a\u6784\u4fe1\u606f\u5217\u8868\u3011", notes="\u6839\u636e\u767b\u9646\u4eba\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/getOrgByLoginUser"})
    public BaseResponse<List<SysOrg>> getOrgByLoginUser() {
        BaseResponse baseResponse = new BaseResponse();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        List list = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId)).or()).like((Object)"parent_ids", (Object)("," + orgId))).eq((Object)"is_dept", (Object)"0")).ne((Object)"status", (Object)"1"));
        baseResponse.setData((Object)list);
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u83b7\u53d6\u672c\u7ea7\u548c\u4e0b\u7ea7\u3011", notes="")
    @GetMapping(value={"/getOrgAndSub"})
    public BaseResponse<List<SysOrg>> getOrgAndSub() {
        BaseResponse baseResponse = new BaseResponse();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        List list = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId)).or()).eq((Object)"parent_id", (Object)orgId)).eq((Object)"is_dept", (Object)"0")).ne((Object)"status", (Object)"1"));
        baseResponse.setData((Object)list);
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u7236\u7ea7id\u83b7\u53d6\u5b50\u96c6\u6570\u636e\u3011", notes="\u6839\u636e\u7236\u7ea7id\u83b7\u53d6\u5b50\u96c6\u6570\u636e")
    @GetMapping(value={"/getOrgByParentId"})
    public BaseResponse<List<SysOrg>> getOrgListByParentId(@RequestParam String parentId) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setData(this.sysOrgService.getOrgListByParentId(parentId));
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u673a\u6784\u540d\u79f0\u6216Id\u83b7\u53d6\u5176\u76f4\u63a5\u5b50\u90e8\u95e8\u3011", notes="\u6839\u636e\u673a\u6784\u540d\u79f0\u6216Id\u83b7\u53d6\u5176\u76f4\u63a5\u5b50\u90e8\u95e8")
    @GetMapping(value={"/sub_list"})
    public BaseResponse<BaseResponseList<DeptAndPost>> childrenEntity(SysOrgParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<SysOrg> queryWrapper = this.orgIdsEntity(param);
        Page resultList = (Page)this.sysOrgService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        List records = resultList.getRecords();
        List collect = records.stream().map(bean -> (DeptAndPost)((Object)((Object)bean.beanToBean(DeptAndPost.class)))).collect(Collectors.toList());
        ArrayList<DeptAndPost> deptAndPosts = new ArrayList<DeptAndPost>();
        for (DeptAndPost item : collect) {
            if (item.getTreeLevel().toString().equals("1")) {
                item.setNature("\u603b\u90e8");
            } else if (item.getTreeLevel().toString().equals("2")) {
                item.setNature("\u533a\u57df\u516c\u53f8");
            } else if (item.getTreeLevel().toString().equals("3")) {
                item.setNature("\u57fa\u5c42\u5355\u4f4d");
            }
            deptAndPosts.add(item);
        }
        baseResponseList.setData(deptAndPosts);
        baseResponseList.setTotal(this.sysOrgService.count((Wrapper)queryWrapper) + "");
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u673a\u6784id\u83b7\u53d6\u5b50\u90e8\u95e8\u53ca\u5c97\u4f4d\u3011", notes="\u6839\u636e\u673a\u6784id\u83b7\u53d6\u5b50\u90e8\u95e8\u53ca\u5c97\u4f4d")
    @GetMapping(value={"/getDeptAndPost"})
    public BaseResponse<BaseResponseList<DeptAndPost>> getDeptAndPost(SysOrgParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<SysOrg> queryWrapper = this.getPost(param);
        Page resultList = (Page)this.sysOrgService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        List records = resultList.getRecords();
        ArrayList<DeptAndPost> deptAndPosts = new ArrayList<DeptAndPost>();
        for (SysOrg record : records) {
            DeptAndPost deptAndPost = (DeptAndPost)((Object)BeanHelper.beanToBean((Object)((Object)record), DeptAndPost.class));
            String orgId = deptAndPost.getOrgId();
            List list = this.tSysPostService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dept_id", (Object)orgId)).ne((Object)"status", (Object)"1"));
            deptAndPost.setTSysPosts(list);
            deptAndPosts.add(deptAndPost);
        }
        baseResponseList.setData(deptAndPosts);
        baseResponseList.setTotal(this.sysOrgService.count((Wrapper)queryWrapper) + "");
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<SysOrg> createQuery(SysOrg queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        return queryWrapper;
    }

    public QueryWrapper<SysOrg> orgIdsEntity(SysOrgParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringHelper.isEmpty((CharSequence)param.getOrgId())) {
            ((QueryWrapper)queryWrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"org_id", (Object)param.getOrgId())).or()).like((Object)"parent_id", (Object)param.getOrgId());
            })).eq((Object)"is_dept", (Object)"0");
        }
        if (!StringHelper.isEmpty((CharSequence)param.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)param.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (!(StringHelper.isEmpty((CharSequence)param.getOrgName()) && StringHelper.isEmpty((CharSequence)param.getLeader()) && StringHelper.isEmpty((CharSequence)param.getOrgCode()) && StringHelper.isEmpty((CharSequence)param.getPhoneNo()))) {
            if (!StringHelper.isEmpty((CharSequence)param.getOrgName())) {
                queryWrapper.like((Object)"org_name", (Object)param.getOrgName());
            }
            if (!StringHelper.isEmpty((CharSequence)param.getLeader())) {
                queryWrapper.like((Object)"leader", (Object)param.getLeader());
            }
            if (!StringHelper.isEmpty((CharSequence)param.getOrgCode())) {
                queryWrapper.like((Object)"org_code", (Object)param.getOrgCode());
            }
            if (!StringHelper.isEmpty((CharSequence)param.getPhoneNo())) {
                queryWrapper.like((Object)"phone_no", (Object)param.getPhoneNo());
            }
        } else if (!StringHelper.isEmpty((CharSequence)param.getKeyword())) {
            queryWrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"org_name", (Object)param.getKeyword())).or()).like((Object)"leader", (Object)param.getKeyword());
            });
        }
        if (!StringHelper.isEmpty((CharSequence)param.getOrderBy())) {
            if (!StringHelper.isEmpty((CharSequence)param.getOrderType()) && "asc".equals(param.getOrderType())) {
                queryWrapper.orderByAsc((Object)param.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)param.getOrderBy());
            }
        } else {
            queryWrapper.orderByAsc((Object[])new String[]{"parent_ids", "tree_sort"});
        }
        return queryWrapper;
    }

    public QueryWrapper<SysOrg> getPost(SysOrgParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringHelper.isEmpty((CharSequence)param.getOrgId())) {
            ((QueryWrapper)queryWrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"org_id", (Object)param.getOrgId())).or()).like((Object)"parent_id", (Object)param.getOrgId());
            })).eq((Object)"is_dept", (Object)"1");
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)param.getOrgName())) {
            queryWrapper.like((Object)"org_name", (Object)param.getOrgName());
        }
        return queryWrapper;
    }

    @ApiOperation(value="\u6839\u636e\u673a\u6784ID\u67e5\u8be2\u673a\u6784", notes="\u6839\u636e\u673a\u6784ID\u67e5\u8be2\u673a\u6784")
    @GetMapping(value={"/get"})
    public BaseResponse<Map<String, Object>> getById(String orgId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isEmpty((CharSequence)orgId)) {
            throw new ApiException(OrgEnumCode.REQUIRED_ITEMS_MISSING.transform());
        }
        SysOrg sysOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)orgId)));
        if (ObjectHelper.isEmpty((Object)((Object)sysOrg))) {
            throw new ApiException(OrgEnumCode.ORG_ID_NOT_EXISTENT.transform());
        }
        Map data = BeanHelper.beanToMap((Object)((Object)sysOrg));
        if (!StringHelper.isEmpty((CharSequence)sysOrg.getParentId()) && !"0".equals(sysOrg.getParentId())) {
            SysOrg parentOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)sysOrg.getParentId())));
            data.put("parentOrgName", parentOrg.getOrgName());
        } else {
            data.put("parentOrgName", "");
        }
        baseResponse.setData((Object)data);
        return baseResponse;
    }

    @ApiOperation(value="excel\u5bfc\u5165", notes="excel\u5bfc\u5165,Upload File")
    @PostMapping(value={"/upload"})
    public BaseResponse<OrgImportResponse> upload(@RequestParam MultipartFile file) {
        BaseResponse baseResponse = new BaseResponse();
        OrgImportResponse userImportResponse = new OrgImportResponse();
        if (file.isEmpty()) {
            throw new ApiException(ExcelEnum.NO_EXPORT_FILE.transform());
        }
        String filepath = this.excelService.importExcel(file);
        TongExcelListener<OrgImport> tongExcelListener = new TongExcelListener<OrgImport>(this.orgExcelImport, OrgImport.class);
        EasyExcel.read((String)filepath, OrgImport.class, tongExcelListener).sheet().doRead();
        List<ImportError<OrgImport>> errorList = tongExcelListener.getErrorList();
        userImportResponse.setErrors(errorList.size() > 19 ? errorList.subList(0, 19) : errorList);
        userImportResponse.setErrorTotal(errorList.size());
        userImportResponse.setSuccessTotal(tongExcelListener.getSuccessList().size());
        userImportResponse.setBeans(ExcelDtoHelper.getCols(new OrgImport()));
        baseResponse.setData((Object)userImportResponse);
        return baseResponse;
    }

    public BaseResponse<TreeVO> returnTreeEntity() {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"parent_id", (Object)"0")).eq((Object)"tree_level", (Object)"1")).ne((Object)"status", (Object)"1");
        List list = this.sysOrgService.list((Wrapper)queryWrapper);
        TreeVO treeVO = null;
        for (SysOrg sysOrg : list) {
            treeVO = (TreeVO)BeanHelper.beanToBean((Object)((Object)sysOrg), TreeVO.class);
            List list1 = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)treeVO.getOrgId())).eq((Object)"tree_level", (Object)"2")).ne((Object)"status", (Object)"1"));
            ArrayList<TreeVO> treeVOS = new ArrayList<TreeVO>();
            for (SysOrg org : list1) {
                TreeVO treeVO1 = (TreeVO)BeanHelper.beanToBean((Object)((Object)org), TreeVO.class);
                List list2 = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)treeVO1.getOrgId())).eq((Object)"tree_level", (Object)"3")).ne((Object)"status", (Object)"1"));
                ArrayList<TreeVO> treeVOS1 = new ArrayList<TreeVO>();
                for (SysOrg sysOrg1 : list2) {
                    TreeVO treeVO2 = (TreeVO)BeanHelper.beanToBean((Object)((Object)sysOrg1), TreeVO.class);
                    treeVOS1.add(treeVO2);
                }
                treeVO1.setChildren(treeVOS1);
                treeVOS.add(treeVO1);
            }
            treeVO.setChildren(treeVOS);
        }
        baseResponse.setData(treeVO);
        return baseResponse;
    }

    public BaseResponse<List<SysOrg>> returnDept() {
        BaseResponse baseResponse = new BaseResponse();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        SysOrg sysOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)orgId)));
        List list = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)sysOrg.getParentId())).eq((Object)"is_dept", (Object)"1")).ne((Object)"status", (Object)"1"));
        baseResponse.setData((Object)list);
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u3011", notes="")
    @GetMapping(value={"/getCurrentOrg"})
    public BaseResponse<SysOrg> getCurrentOrg() {
        BaseResponse sysOrgBaseResponse = new BaseResponse();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        SysOrg one = (SysOrg)((Object)this.sysOrgService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId)).ne((Object)"status", (Object)"1")));
        sysOrgBaseResponse.setData((Object)one);
        return sysOrgBaseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u673a\u6784id\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u3011", notes="")
    @GetMapping(value={"/gainDept"})
    public BaseResponse<List<SysOrg>> gainDept(String orgId) {
        BaseResponse sysOrgBaseResponse = new BaseResponse();
        List list = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)orgId)).eq((Object)"is_dept", (Object)"1")).ne((Object)"status", (Object)"1"));
        sysOrgBaseResponse.setData((Object)list);
        return sysOrgBaseResponse;
    }
}

