/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.org.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.org.dao.SysOrgDao;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.jsonwebtoken.lang.Collections;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysOrgServiceImpl
extends SuperServiceImpl<SysOrgDao, SysOrg>
implements SysOrgService {
    @Autowired
    private SysOrgDao sysOrgDao;

    @Override
    public List<SysOrg> getChildrenById(String orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"status", (Object)"0")).eq((Object)"is_dept", (Object)"0")).and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"org_id", (Object)orgId)).or()).like((Object)"parent_ids", (Object)("," + orgId));
        })).orderByAsc((Object[])new String[]{"tree_level", "tree_sort"});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public String getOrgFullPathName(String orgId) {
        StringBuilder fullName = new StringBuilder();
        SysOrg sysOrg = (SysOrg)((Object)this.getById((Serializable)((Object)orgId)));
        List pIds = Collections.arrayToList((Object)StringHelper.split((String)sysOrg.getParentIds(), (String)","));
        int size = pIds.size();
        if (2 <= size) {
            for (String pid : pIds) {
                SysOrg pOrg;
                if ("0".equals(pid) || !ObjectHelper.isNotEmpty((Object)((Object)(pOrg = (SysOrg)((Object)this.getById((Serializable)((Object)pid))))))) continue;
                fullName.append(pOrg.getOrgName()).append("/");
            }
        }
        fullName.append(sysOrg.getOrgName());
        return fullName.toString();
    }

    @Override
    public List<SysOrg> getOrgListByParentId(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"status", (Object)"0")).eq((Object)"is_dept", (Object)"0")).and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"parent_id", (Object)parentId);
        })).orderByAsc((Object[])new String[]{"tree_level", "tree_sort"});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SysOrg> getOrgAllByLoginUser() {
        return this.sysOrgDao.getOrgAllByLoginUser(ContextUtils.getLoginUser().getParentIds(), ContextUtils.getLoginUser().getOrgId());
    }

    @Override
    public List<SysOrg> getChildrenDept(String orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"status", (Object)"0")).eq((Object)"is_dept", (Object)"1")).and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"parent_id", (Object)orgId);
        })).orderByAsc((Object[])new String[]{"tree_level", "tree_sort"});
        return this.list((Wrapper)queryWrapper);
    }
}

