/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument.push;

import com.tongweb.commons.monitor.core.instrument.Clock;
import com.tongweb.commons.monitor.core.instrument.MeterRegistry;
import com.tongweb.commons.monitor.core.instrument.push.PushRegistryConfig;
import com.tongweb.commons.monitor.core.instrument.util.TimeUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PushMeterRegistry
extends MeterRegistry {
    private static final Log logger = LogFactory.getLog((String)"monitor");
    private final PushRegistryConfig config;
    private ScheduledExecutorService scheduledExecutorService;

    protected PushMeterRegistry(PushRegistryConfig config, Clock clock) {
        super(clock);
        config.requireValid();
        this.config = config;
    }

    protected abstract void publish();

    private void publishSafely() {
        try {
            this.publish();
        }
        catch (Throwable e) {
            logger.warn((Object)("Unexpected exception thrown while publishing metrics for " + this.getClass().getSimpleName()), e);
        }
    }

    @Deprecated
    public final void start() {
        this.start(Executors.defaultThreadFactory());
    }

    public void start(ThreadFactory threadFactory) {
        if (this.scheduledExecutorService != null) {
            this.stop();
        }
        if (this.config.enabled()) {
            logger.info((Object)("publishing metrics for " + this.getClass().getSimpleName() + " every " + TimeUtils.format(this.config.step())));
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.scheduledExecutorService.scheduleAtFixedRate(this::publishSafely, this.config.step().toMillis(), this.config.step().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public void close() {
        if (this.config.enabled()) {
            this.publishSafely();
        }
        this.stop();
        super.close();
    }
}

