/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure;

import com.tongtech.commons.utils.StringUtils;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Configuration
public class JspPrecompilationConfigure {
    private static final Log log = LogFactory.getLog(JspPrecompilationConfigure.class);
    @Autowired
    private WebMvcProperties mvcProperties;

    @Bean
    @ConditionalOnProperty(name={"server.tongweb.jsp-precompilation-enabled"}, havingValue="true")
    public ServletContextInitializer preCompileJspsAtStartup() {
        String prefix = this.mvcProperties.getView().getPrefix();
        if (StringUtils.isEmpty((Object)prefix)) {
            prefix = "/WEB-INF/jsp/";
        }
        String finalPrefix = prefix;
        return servletContext -> JspPrecompilationConfigure.getDeepResourcePaths(servletContext, finalPrefix).forEach(jspPath -> {
            if (jspPath.endsWith(".jsp")) {
                log.info((Object)("Registering JSP: {" + jspPath + "}"));
                ServletRegistration.Dynamic reg = servletContext.addServlet(jspPath, "com.tongweb.jasper.servlet.JspServlet");
                reg.setInitParameter("jspFile", jspPath);
                reg.setInitParameter("genStringAsCharArray", "true");
                reg.setInitParameter("trimSpaces", "true");
                reg.setInitParameter("development", "false");
                reg.setLoadOnStartup(99);
                reg.addMapping(new String[]{jspPath});
            }
        });
    }

    private static Stream<String> getDeepResourcePaths(ServletContext servletContext, String path) {
        return path.endsWith("/") ? servletContext.getResourcePaths(path).stream().flatMap(p -> JspPrecompilationConfigure.getDeepResourcePaths(servletContext, p)) : Stream.of(path);
    }
}

