/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.models.exceptions;

import com.tongtech.tfw.backend.common.constants.enumeration.ApiStatusCodeEnum;
import com.tongtech.tfw.backend.common.constants.enumeration.HttpStatusCodeEnum;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;

public class ApiException
extends RuntimeException {
    private static final long serialVersionUID = -2344691769119882244L;
    private final ResponseInfo responseInfo;

    public ApiException(HttpStatusCodeEnum httpStatusCodeEnum) {
        super(httpStatusCodeEnum.msg());
        this.responseInfo = ResponseInfo.transformHttpStatus(httpStatusCodeEnum);
    }

    public ApiException(ApiStatusCodeEnum apiStatusCodeEnum) {
        super(apiStatusCodeEnum.msg());
        this.responseInfo = ResponseInfo.transformApiStatus(apiStatusCodeEnum);
    }

    public ApiException(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }
}

