/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.request;

import com.tongtech.tfw.backend.common.constants.HttpConstants;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.core.constants.enumeration.HttpMethodEnum;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.json.JacksonHelper;
import com.tongtech.tfw.backend.core.helper.map.MapKeyComparator;
import com.tongtech.tfw.backend.core.models.exceptions.FrameworkException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);

    public static String getRequestBody(HttpServletRequest request) {
        String requestBody = null;
        if (RequestUtil.isContainsBody(request)) {
            try {
                if (ObjectHelper.isNotEmpty((Object)request.getInputStream())) {
                    requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
                } else if (ObjectHelper.isNotEmpty((Object)request.getParameterMap())) {
                    Map pam = request.getParameterMap();
                    if (ObjectHelper.isNotEmpty((Object)pam) && pam.size() > 0) {
                        pam = MapKeyComparator.sortMapByKey((Map)pam);
                    }
                    StringBuilder data = new StringBuilder();
                    for (String key : pam.keySet()) {
                        String value = Arrays.toString((Object[])pam.get(key));
                        data.append(key).append(StringHelper.substring((String)value, (int)1, (int)(value.length() - 1)));
                    }
                    requestBody = data.toString();
                }
            }
            catch (IOException ex) {
                throw new FrameworkException((Throwable)ex);
            }
        }
        return requestBody;
    }

    public static Map<String, String[]> getParameterMap(HttpServletRequest request) {
        Map<String, Object> parameterMap = new HashMap<String, String[]>(16);
        try {
            Map pam;
            if (ObjectHelper.isNotEmpty((Object)request.getParameterMap()) && ObjectHelper.isNotEmpty((Object)(pam = request.getParameterMap())) && pam.size() > 0) {
                pam = MapKeyComparator.sortMapByKey((Map)pam);
                parameterMap = pam;
            }
        }
        catch (Exception ex) {
            log.error("Request Parameter Map Locked:" + ex);
        }
        return parameterMap;
    }

    public static byte[] getByteBody(HttpServletRequest request) {
        byte[] requestBody = new byte[]{};
        try {
            requestBody = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            log.error("Error: Get Request Body fail", (Throwable)e);
        }
        return requestBody;
    }

    public static boolean isContainsBody(HttpServletRequest request) {
        return RequestUtil.isPost(request) || RequestUtil.isPut(request) || RequestUtil.isPatch(request);
    }

    public static boolean isPost(HttpServletRequest request) {
        return HttpMethodEnum.POST.toString().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPut(HttpServletRequest request) {
        return HttpMethodEnum.PUT.toString().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPatch(HttpServletRequest request) {
        return HttpMethodEnum.PATCH.toString().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isGet(HttpServletRequest request) {
        return HttpMethodEnum.GET.toString().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isDelete(HttpServletRequest request) {
        return HttpMethodEnum.DELETE.toString().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isTrace(HttpServletRequest request) {
        return HttpMethodEnum.TRACE.toString().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isHead(HttpServletRequest request) {
        return HttpMethodEnum.HEAD.toString().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isOptions(HttpServletRequest request) {
        return HttpMethodEnum.OPTIONS.toString().equalsIgnoreCase(request.getMethod());
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (StringHelper.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (StringHelper.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringHelper.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringHelper.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (null != ip && ip.length() > HttpConstants.IP_MIN_LENGTH && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public static HttpServletRequest getRequest() {
        Optional<ServletRequestAttributes> servletRequestAttributes = Optional.ofNullable((ServletRequestAttributes)RequestContextHolder.getRequestAttributes());
        return servletRequestAttributes.map(ServletRequestAttributes::getRequest).orElse(null);
    }

    public static RequestAttributes getRequestAttributes() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes;
    }

    public static String getToken(HttpServletRequest httpRequest) {
        String token = (String)httpRequest.getAttribute("accessToken");
        if (StringHelper.isBlank((CharSequence)token)) {
            token = httpRequest.getHeader("Authorization");
        }
        if (StringHelper.isBlank((CharSequence)token)) {
            token = httpRequest.getParameter("accessToken");
        }
        if (StringHelper.isBlank((CharSequence)token)) {
            if (ObjectHelper.isNotEmpty((Object)RequestUtil.getRequestBody(httpRequest))) {
                Optional<Object> bodyMap = Optional.ofNullable(JacksonHelper.readValue((String)RequestUtil.getRequestBody(httpRequest), HashMap.class));
                token = TypeHelper.castToString(bodyMap.map(t -> t.get("accessToken")).orElse(null));
            } else {
                throw new ApiException(BaseStatusEnum.UN_TOKEN.transform());
            }
        }
        return StringHelper.isBlank((CharSequence)token) ? null : token.replaceFirst("Bearer", "");
    }

    public static Long getTimestamp(HttpServletRequest httpRequest) {
        String timeStamp = (String)httpRequest.getAttribute("timestamp");
        if (StringHelper.isBlank((CharSequence)timeStamp)) {
            timeStamp = httpRequest.getHeader("timestamp");
        }
        if (StringHelper.isBlank((CharSequence)timeStamp)) {
            timeStamp = httpRequest.getParameter("timestamp");
        }
        if (StringHelper.isBlank((CharSequence)timeStamp)) {
            if (ObjectHelper.isNotEmpty((Object)RequestUtil.getRequestBody(httpRequest))) {
                Optional<Object> bodyMap = Optional.ofNullable(JacksonHelper.readValue((String)RequestUtil.getRequestBody(httpRequest), HashMap.class));
                timeStamp = TypeHelper.castToString(bodyMap.map(t -> t.get("timestamp")).orElse(null));
            } else {
                throw new ApiException(BaseStatusEnum.UN_TIMESTAMP.transform());
            }
        }
        return StringHelper.isBlank((CharSequence)timeStamp) ? null : Long.valueOf(timeStamp.trim());
    }

    public static String getDataSign(HttpServletRequest httpRequest) {
        String dataSign = (String)httpRequest.getAttribute("sign");
        if (StringHelper.isBlank((CharSequence)dataSign)) {
            dataSign = httpRequest.getHeader("sign");
        }
        if (StringHelper.isBlank((CharSequence)dataSign)) {
            dataSign = httpRequest.getParameter("sign");
        }
        if (StringHelper.isBlank((CharSequence)dataSign)) {
            if (ObjectHelper.isNotEmpty((Object)RequestUtil.getRequestBody(httpRequest))) {
                Optional<Object> bodyMap = Optional.ofNullable(JacksonHelper.readValue((String)RequestUtil.getRequestBody(httpRequest), HashMap.class));
                dataSign = TypeHelper.castToString(bodyMap.map(t -> t.get("sign")).orElse(null));
            } else {
                throw new ApiException(BaseStatusEnum.UN_SIGN.transform());
            }
        }
        return StringHelper.isBlank((CharSequence)dataSign) ? null : dataSign.trim();
    }
}

