/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.commons.utils;

import com.tongtech.commons.utils.RetryFunction;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class Retry<T, R> {
    private int retryLimit = 3;
    private int retrySleep = 0;

    public R doRetry(T t, RetryFunction<T, R> function) throws Exception {
        return this.doRetry(t, function, 1);
    }

    public R doRetry(T t, RetryFunction<T, R> function, int time) throws Exception {
        try {
            return function.apply(t);
        }
        catch (IOException e2) {
            if (time < this.retryLimit) {
                if (this.retrySleep != 0) {
                    TimeUnit.MILLISECONDS.sleep(this.retrySleep);
                }
                return this.doRetry(t, function, ++time);
            }
            throw e2;
        }
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public int getRetrySleep() {
        return this.retrySleep;
    }

    public void setRetrySleep(int retrySleep) {
        if (retrySleep >= 0) {
            this.retrySleep = retrySleep;
        }
    }
}

