/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Future;

public class FileUtil {
    public static String propFileEncoding = Charset.defaultCharset().toString();

    public static String readFile(String filePath) throws IOException {
        return FileUtil.readFile(new File(filePath));
    }

    public static String readFile(File file) throws IOException {
        return FileUtil.readFile(new FileReader(file));
    }

    public static String readFile(FileReader fileReader) throws IOException {
        try (BufferedReader in = new BufferedReader(fileReader);){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\r\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String getSystemDeployDirectory() {
        try {
            File project = new File("").getCanonicalFile();
            return project.getPath() + File.separator;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static boolean saveConfig(String fileContent, String fileName) {
        try {
            File configFile = new File(fileName);
            if (!configFile.exists()) {
                if (!configFile.getParentFile().exists()) {
                    configFile.getParentFile().mkdirs();
                }
                configFile.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(configFile.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fileWriter);
            bw.write(fileContent);
            bw.close();
        }
        catch (IOException e2) {
            return false;
        }
        return true;
    }

    public static void createFile(String fileName) throws IOException {
        File configFile = new File(fileName);
        configFile.delete();
        if (configFile.getParentFile() != null && !configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdirs();
        }
        configFile.createNewFile();
    }

    public static boolean asyncSaveConfig(String fileContent, String fileName) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        FileUtil.createFile(fileName);
        try (AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(path, StandardOpenOption.WRITE);){
            ByteBuffer buffer = ByteBuffer.allocate(fileContent.getBytes(propFileEncoding).length);
            long position = 0L;
            buffer.put(fileContent.getBytes(propFileEncoding));
            buffer.flip();
            Future<Integer> operation = fileChannel.write(buffer, position);
            buffer.clear();
            while (!operation.isDone()) {
            }
        }
        return true;
    }

    public static Boolean exist(String file) {
        return FileUtil.exist(new File(file));
    }

    public static Boolean exist(File file) {
        if (null == file) {
            return false;
        }
        return file.exists();
    }

    public static Boolean canRead(String file) {
        if (file == null || file.length() == 0) {
            return false;
        }
        return FileUtil.canRead(new File(file));
    }

    public static Boolean canRead(File file) {
        if (file == null) {
            return false;
        }
        return file.canRead();
    }

    public static Boolean canWrite(File file) {
        if (file.isDirectory()) {
            try {
                file = new File(file, "canWriteTestDeleteOnExit.temp");
                if (file.exists()) {
                    boolean checkWrite = FileUtil.checkWrite(file);
                    if (!FileUtil.deleteFile(file)) {
                        file.deleteOnExit();
                    }
                    return checkWrite;
                }
                if (file.createNewFile()) {
                    if (!FileUtil.deleteFile(file)) {
                        file.deleteOnExit();
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return FileUtil.checkWrite(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkWrite(File file) {
        FileWriter fw = null;
        boolean delete = !file.exists();
        boolean result = false;
        try {
            fw = new FileWriter(file, true);
            fw.write("");
            fw.flush();
            fw.close();
            boolean bl = result = true;
            return bl;
        }
        catch (IOException e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (delete && result) {
                FileUtil.deleteFile(file);
            }
        }
    }

    public static boolean deleteFile(File file) {
        return FileUtil.deleteFile(file, true);
    }

    public static boolean deleteFile(File file, boolean delDir) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        boolean result = true;
        File[] children = file.listFiles();
        for (int i2 = 0; i2 < children.length; ++i2) {
            result = FileUtil.deleteFile(children[i2], delDir);
            if (result) continue;
            return false;
        }
        if (delDir) {
            result = file.delete();
        }
        return result;
    }

    static {
        propFileEncoding = System.getProperty("properties.file.encoding", propFileEncoding);
    }
}

