/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.admin.apis.biz.gen.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tongtech.tfw.backend.admin.apis.biz.gen.dao.GenTableColumnMapper;
import com.tongtech.tfw.backend.admin.apis.biz.gen.dao.GenTableMapper;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.GenTable;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.GenTableColumn;
import com.tongtech.tfw.backend.admin.apis.biz.gen.service.IGenTableService;
import com.tongtech.tfw.backend.admin.apis.biz.gen.util.GenUtils;
import com.tongtech.tfw.backend.admin.apis.biz.gen.util.VelocityInitializer;
import com.tongtech.tfw.backend.admin.apis.biz.gen.util.VelocityUtils;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.json.JacksonHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GenTableServiceImpl
implements IGenTableService {
    private static final Logger log = LoggerFactory.getLogger(GenTableServiceImpl.class);
    @Autowired(required=false)
    private GenTableMapper genTableMapper;
    @Autowired(required=false)
    private GenTableColumnMapper genTableColumnMapper;

    @Override
    public GenTable selectGenTableById(Long id) {
        GenTable genTable = this.genTableMapper.selectGenTableById(id);
        List<GenTableColumn> columns = genTable.getColumns();
        this.setPkColumn(genTable, columns);
        this.setTableFromOptions(genTable);
        return genTable;
    }

    @Override
    public IPage<GenTable> selectGenTableList(IPage<GenTable> page, GenTable genTable) {
        return this.genTableMapper.selectGenTableList(page, genTable);
    }

    @Override
    public IPage<GenTable> selectDbTableList(IPage<GenTable> page, GenTable genTable) {
        return this.genTableMapper.selectDbTableList(page, genTable);
    }

    @Override
    public List<GenTable> selectDbTableListByNames(String[] tableNames) {
        return this.genTableMapper.selectDbTableListByNames(tableNames);
    }

    @Override
    @Transactional
    public void updateGenTable(GenTable genTable) {
        String options = JacksonHelper.toJson(genTable.getParams());
        genTable.setOptions(options);
        int row = this.genTableMapper.updateGenTable(genTable);
        if (row > 0) {
            for (GenTableColumn cenTableColumn : genTable.getColumns()) {
                this.genTableColumnMapper.updateGenTableColumn(cenTableColumn);
            }
        }
    }

    @Override
    @Transactional
    public void deleteGenTableByIds(Long[] tableIds) {
        this.genTableMapper.deleteGenTableByIds(tableIds);
        this.genTableColumnMapper.deleteGenTableColumnByIds(tableIds);
    }

    @Override
    @Transactional
    public void importGenTable(List<GenTable> tableList, String operName) {
        for (GenTable table : tableList) {
            try {
                String tableName = table.getTableName();
                GenUtils.initTable(table, operName);
                int row = this.genTableMapper.insertGenTable(table);
                if (row <= 0) continue;
                List<GenTableColumn> genTableColumns = this.genTableColumnMapper.selectDbTableColumnsByName(tableName);
                for (GenTableColumn column : genTableColumns) {
                    GenUtils.initColumnField(column, table);
                    this.genTableColumnMapper.insertGenTableColumn(column);
                }
            }
            catch (Exception e) {
                log.error("\u8868\u540d " + table.getTableName() + " \u5bfc\u5165\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, String> previewCode(Long tableId) {
        List<String> pTableParam;
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        GenTable table = this.genTableMapper.selectGenTableById(tableId);
        List<GenTableColumn> columns = table.getColumns();
        this.setPkColumn(table, columns);
        VelocityInitializer.initVelocity();
        GenTable pTable = null;
        if ("tree-table".equals(table.getTplCategory()) && !(pTableParam = this.getParentTableParam(table)).isEmpty()) {
            pTable = this.genTableMapper.selectGenTableByName(pTableParam.get(0));
            List<GenTableColumn> pColumns = pTable.getColumns();
            this.setPkColumn(pTable, pColumns);
        }
        VelocityContext context = VelocityUtils.prepareContext(table, pTable);
        List<String> templates = VelocityUtils.getTemplateList(table.getTplCategory());
        for (String template : templates) {
            StringWriter sw = new StringWriter();
            Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
            tpl.merge((Context)context, (Writer)sw);
            dataMap.put(template, sw.toString());
        }
        return dataMap;
    }

    @Override
    public byte[] generatorCode(String tableName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        this.generatorCode(tableName, zip);
        try {
            zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    @Override
    public byte[] generatorCode(String[] tableNames) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        for (String tableName : tableNames) {
            this.generatorCode(tableName, zip);
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    private void generatorCode(String tableName, ZipOutputStream zip) {
        List<String> pTableParam;
        GenTable table = this.genTableMapper.selectGenTableByName(tableName);
        List<GenTableColumn> columns = table.getColumns();
        this.setPkColumn(table, columns);
        VelocityInitializer.initVelocity();
        GenTable pTable = null;
        if ("tree-table".equals(table.getTplCategory()) && !(pTableParam = this.getParentTableParam(table)).isEmpty()) {
            pTable = this.genTableMapper.selectGenTableByName(pTableParam.get(0));
            List<GenTableColumn> pColumns = pTable.getColumns();
            this.setPkColumn(pTable, pColumns);
        }
        VelocityContext context = VelocityUtils.prepareContext(table, pTable);
        List<String> templates = VelocityUtils.getTemplateList(table.getTplCategory());
        for (String template : templates) {
            StringWriter sw = new StringWriter();
            Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
            tpl.merge((Context)context, (Writer)sw);
            try {
                zip.putNextEntry(new ZipEntry(VelocityUtils.getFileName(template, table)));
                IOUtils.write((String)sw.toString(), (OutputStream)zip, (String)"UTF-8");
                try {
                    sw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                zip.flush();
                zip.closeEntry();
            }
            catch (IOException e) {
                log.error("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + table.getTableName(), (Throwable)e);
            }
        }
    }

    @Override
    public void validateEdit(GenTable genTable) {
        String options;
        if ("tree".equals(genTable.getTplCategory()) && StringHelper.isNotEmpty((CharSequence)(options = JacksonHelper.toJson(genTable.getParams())))) {
            JsonParser jsonParser = new JsonParser();
            JsonElement element = jsonParser.parse(options);
            JsonObject paramsObj = element.getAsJsonObject();
            if (ObjectHelper.isEmpty((Object)paramsObj.get("treeCode")) || paramsObj.get("treeCode").isJsonNull()) {
                throw new ApiException(new ResponseInfo(200, "\u6811\u7f16\u7801\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (ObjectHelper.isEmpty((Object)paramsObj.get("treeParentCode")) || paramsObj.get("treeParentCode").isJsonNull()) {
                throw new ApiException(new ResponseInfo(200, "\u6811\u7236\u7f16\u7801\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (ObjectHelper.isEmpty((Object)paramsObj.get("treeName")) || paramsObj.get("treeName").isJsonNull()) {
                throw new ApiException(new ResponseInfo(200, "\u6811\u540d\u79f0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        }
    }

    public void setPkColumn(GenTable table, List<GenTableColumn> columns) {
        for (GenTableColumn column : columns) {
            if (!column.isPk()) continue;
            table.setPkColumn(column);
            break;
        }
        if (ObjectHelper.isEmpty((Object)table.getPkColumn())) {
            table.setPkColumn(columns.get(0));
        }
    }

    public void setTableFromOptions(GenTable genTable) {
        JsonParser jsonParser;
        JsonElement element;
        JsonObject paramsObj;
        if (ObjectHelper.isNotEmpty((Object)genTable) && StringHelper.isNotEmpty((CharSequence)genTable.getOptions()) && ObjectHelper.isNotEmpty((Object)(paramsObj = (element = (jsonParser = new JsonParser()).parse(genTable.getOptions())).getAsJsonObject()))) {
            String treeCode = ObjectHelper.isEmpty((Object)paramsObj.get("treeCode")) || paramsObj.get("treeCode").isJsonNull() ? null : paramsObj.getAsJsonPrimitive("treeCode").getAsString();
            String treeParentCode = ObjectHelper.isEmpty((Object)paramsObj.get("treeParentCode")) || paramsObj.get("treeParentCode").isJsonNull() ? null : paramsObj.getAsJsonPrimitive("treeParentCode").getAsString();
            String treeName = ObjectHelper.isEmpty((Object)paramsObj.get("treeName")) || paramsObj.get("treeName").isJsonNull() ? null : paramsObj.getAsJsonPrimitive("treeName").getAsString();
            String pTableName = ObjectHelper.isEmpty((Object)paramsObj.get("pTableName")) || paramsObj.get("pTableName").isJsonNull() ? null : paramsObj.getAsJsonPrimitive("pTableName").getAsString();
            String fkFieldName = ObjectHelper.isEmpty((Object)paramsObj.get("fkFieldName")) || paramsObj.get("fkFieldName").isJsonNull() ? null : paramsObj.getAsJsonPrimitive("fkFieldName").getAsString();
            genTable.setTreeCode(treeCode);
            genTable.setTreeParentCode(treeParentCode);
            genTable.setTreeName(treeName);
            genTable.setpTableName(pTableName);
            genTable.setFkFieldName(fkFieldName);
        }
    }

    private List<String> getParentTableParam(GenTable genTable) {
        JsonParser jsonParser;
        JsonElement element;
        JsonObject paramsObj;
        ArrayList<String> pTableParam = new ArrayList<String>(5);
        if (ObjectHelper.isNotEmpty((Object)genTable) && StringHelper.isNotEmpty((CharSequence)genTable.getOptions()) && ObjectHelper.isNotEmpty((Object)(paramsObj = (element = (jsonParser = new JsonParser()).parse(genTable.getOptions())).getAsJsonObject()))) {
            String fkFieldName;
            String pTableName = ObjectHelper.isEmpty((Object)paramsObj.get("pTableName")) || paramsObj.get("pTableName").isJsonNull() ? null : paramsObj.getAsJsonPrimitive("pTableName").getAsString();
            String string = fkFieldName = ObjectHelper.isEmpty((Object)paramsObj.get("fkFieldName")) || paramsObj.get("fkFieldName").isJsonNull() ? null : paramsObj.getAsJsonPrimitive("fkFieldName").getAsString();
            if (StringHelper.isNotEmpty((CharSequence)pTableName) && StringHelper.isNotEmpty(fkFieldName)) {
                pTableParam.add(pTableName);
                pTableParam.add(fkFieldName);
            } else {
                throw new ApiException(new ResponseInfo(200, "\u7236\u8868\u540d\u79f0\u4ee5\u53ca\u5916\u952e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        }
        return pTableParam;
    }
}

