/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.util;

import com.tongweb.container.util.ExtremeMode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class Utils {
    public static final String CURRENT_TIME_THREAD_NAME = "TW-Timer-Cache";

    public static long getCurrentTime() {
        if (ExtremeMode.t_c.getFlag()) {
            return TimerUtil.getCurrentTime();
        }
        return System.currentTimeMillis();
    }

    private static int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[1]);
            bb.get(buffer, offset + location, count);
        }
        return length - remaining;
    }

    private static int readWithNIO(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, offset, length);
        ReadableByteChannel inChannel = Channels.newChannel(input);
        int bytesRead = 0;
        while (byteBuffer.hasRemaining() && bytesRead != -1 && (bytesRead = inChannel.read(byteBuffer)) != -1) {
        }
        if (byteBuffer.position() < byteBuffer.limit()) {
            byteBuffer.flip();
        }
        return byteBuffer.position() - offset;
    }

    private static class TimerUtil {
        private static volatile long currentTime;

        private TimerUtil() {
        }

        public static long getCurrentTime() {
            return currentTime;
        }

        static {
            CurrentTime tm = new CurrentTime();
            tm.setDaemon(true);
            tm.start();
        }

        private static class CurrentTime
        extends Thread {
            protected CurrentTime() {
                currentTime = System.currentTimeMillis();
                this.setContextClassLoader(null);
                this.setName(Utils.CURRENT_TIME_THREAD_NAME);
            }

            @Override
            public void run() {
                while (true) {
                    currentTime = System.currentTimeMillis();
                    try {
                        Thread.sleep(51L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }
    }
}

