/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.net.gmjsse;

import com.tongweb.web.util.net.SSLContext;
import com.tongweb.web.util.net.gmjsse.GMConstant;
import com.tongweb.web.util.net.gmjsse.GMSSLEngine;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

class GMSSLContext
implements SSLContext {
    private javax.net.ssl.SSLContext context;
    private KeyManager[] kms;
    private TrustManager[] tms;

    GMSSLContext(String protocol) throws Exception {
        this(protocol, null);
    }

    GMSSLContext(String protocol, String provider) throws Exception {
        this.context = provider == null ? javax.net.ssl.SSLContext.getInstance(protocol) : javax.net.ssl.SSLContext.getInstance(protocol, provider);
    }

    @Override
    public void init(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        this.kms = kms;
        this.tms = tms;
        this.context.init(kms, tms, sr);
    }

    @Override
    public void destroy() {
    }

    @Override
    public SSLSessionContext getServerSessionContext() {
        return this.context.getServerSessionContext();
    }

    @Override
    public SSLEngine createSSLEngine() {
        SSLEngine sslEngine = this.context.createSSLEngine();
        sslEngine.setEnabledCipherSuites(GMConstant.GM_CIPHERS);
        sslEngine.setEnabledProtocols(new String[]{GMConstant.GM_PROTOCOL});
        return new GMSSLEngine(sslEngine);
    }

    @Override
    public SSLServerSocketFactory getServerSocketFactory() {
        return this.context.getServerSocketFactory();
    }

    @Override
    public SSLParameters getSupportedSSLParameters() {
        return this.context.getSupportedSSLParameters();
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] result = null;
        if (this.kms != null) {
            for (int i = 0; i < this.kms.length && result == null; ++i) {
                if (!(this.kms[i] instanceof X509KeyManager)) continue;
                result = ((X509KeyManager)this.kms[i]).getCertificateChain(alias);
            }
        }
        return result;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        if (this.tms != null) {
            for (int i = 0; i < this.tms.length; ++i) {
                X509Certificate[] accepted;
                TrustManager tms = this.tms[i];
                if (!(tms instanceof X509TrustManager) || (accepted = ((X509TrustManager)tms).getAcceptedIssuers()) == null) continue;
                certs.addAll(Arrays.asList(accepted));
            }
        }
        return certs.toArray(new X509Certificate[0]);
    }
}

