/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.dataview.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.dataview.DataviewEnumCode;
import com.tongtech.tfw.dataview.model.domain.TDataviewCategory;
import com.tongtech.tfw.dataview.model.dto.TDataviewCategoryDelParam;
import com.tongtech.tfw.dataview.model.dto.TDataviewCategoryParam;
import com.tongtech.tfw.dataview.service.TDataviewCategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dataview/category"})
@Api(value="TDataviewCategory", tags={"DataView \u53ef\u89c6\u5316\u5206\u7c7b"})
public class TDataviewCategoryController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(TDataviewCategoryController.class);
    @Autowired
    private TDataviewCategoryService tDataviewCategoryService;

    @ApiOperation(value="\u65b0\u589e \u53ef\u89c6\u5316\u5206\u7c7b", notes="\u65b0\u589e \u53ef\u89c6\u5316\u5206\u7c7b Add TDataviewCategory")
    @PostMapping(value={"/add"})
    public BaseResponse<TDataviewCategory> addEntity(@RequestBody TDataviewCategory addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)addRequest))) {
            String id = IdHelper.getId32bit();
            List tDataviewCategory = this.tDataviewCategoryService.list((Wrapper)new QueryWrapper().lambda().eq(TDataviewCategory::getCategoryKey, (Object)addRequest.getCategoryKey()));
            if (!tDataviewCategory.isEmpty()) {
                throw new ApiException(DataviewEnumCode.CATEGORY_EXISTED.transform());
            }
            TDataviewCategory data = (TDataviewCategory)((Object)BeanHelper.beanToBean((Object)((Object)addRequest), TDataviewCategory.class));
            data.setId(id);
            boolean result = this.tDataviewCategoryService.save((Object)data);
            if (result) {
                TDataviewCategory newEntity = new TDataviewCategory();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b by param", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b Get TDataviewCategory By param")
    @GetMapping(value={"/detail"})
    public BaseResponse<TDataviewCategory> getById(TDataviewCategoryParam param) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)param))) {
            QueryWrapper<TDataviewCategory> queryWrapper = this.createQuery(param);
            TDataviewCategory data = (TDataviewCategory)((Object)this.tDataviewCategoryService.getOne((Wrapper)queryWrapper));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b ", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b Get TDataviewCategory By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<TDataviewCategory> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)id)) {
            TDataviewCategory data = (TDataviewCategory)((Object)this.tDataviewCategoryService.getById((Serializable)((Object)id)));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u53ef\u89c6\u5316\u5206\u7c7b ", notes="\u4fee\u6539 \u53ef\u89c6\u5316\u5206\u7c7b Update TDataviewCategory By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TDataviewCategory updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)updateRequest)) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            TDataviewCategory data = (TDataviewCategory)((Object)BeanHelper.beanToBean((Object)((Object)updateRequest), TDataviewCategory.class));
            boolean result = this.tDataviewCategoryService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u53ef\u89c6\u5316\u5206\u7c7b ", notes="\u5220\u9664 \u53ef\u89c6\u5316\u5206\u7c7b delete TDataviewCategory By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TDataviewCategoryDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            TDataviewCategory data = new TDataviewCategory();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.tDataviewCategoryService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316\u5206\u7c7b", notes="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316\u5206\u7c7b delete TDataviewCategory by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody TDataviewCategoryDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<TDataviewCategory> tDataviewCategoryList = new ArrayList<TDataviewCategory>();
            for (String id : deleteRequest.getIds()) {
                TDataviewCategory data = new TDataviewCategory();
                data.setId(id);
                data.setStatus("1");
                tDataviewCategoryList.add(data);
            }
            boolean result = this.tDataviewCategoryService.updateBatchById(tDataviewCategoryList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b \u5206\u9875\u5217\u8868", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b \u5206\u9875\u5217\u8868 List TDataviewCategory with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<TDataviewCategory>> listEntity(TDataviewCategoryParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<TDataviewCategory> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.tDataviewCategoryService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b \u5217\u8868", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b \u5217\u8868 List TDataviewCategory all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<TDataviewCategory>> listAllEntity(TDataviewCategoryParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<TDataviewCategory> queryWrapper = this.createQuery(param);
        List resultList = this.tDataviewCategoryService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<TDataviewCategory> createQuery(TDataviewCategoryParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getCategoryKey())) {
            queryWrapper.eq((Object)"category_key", (Object)queryParam.getCategoryKey());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getCategoryValue())) {
            queryWrapper.eq((Object)"category_value", (Object)queryParam.getCategoryValue());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getIsDeleted())) {
            queryWrapper.eq((Object)"is_deleted", (Object)queryParam.getIsDeleted());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

