/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.dataview.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.dataview.model.domain.TDataviewMap;
import com.tongtech.tfw.dataview.model.dto.TDataviewMapDelParam;
import com.tongtech.tfw.dataview.model.dto.TDataviewMapParam;
import com.tongtech.tfw.dataview.service.TDataviewMapService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dataview/map"})
@Api(value="TDataviewMap", tags={"DataView \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e"})
public class TDataviewMapController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(TDataviewMapController.class);
    @Autowired
    private TDataviewMapService tDataviewMapService;

    @ApiOperation(value="\u65b0\u589e \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e", notes="\u65b0\u589e \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e Add TDataviewMap")
    @PostMapping(value={"/add"})
    public BaseResponse<TDataviewMap> addEntity(@RequestBody TDataviewMap addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)addRequest))) {
            String id = IdHelper.getId32bit();
            TDataviewMap data = (TDataviewMap)((Object)BeanHelper.beanToBean((Object)((Object)addRequest), TDataviewMap.class));
            data.setId(id);
            boolean result = this.tDataviewMapService.save((Object)data);
            if (result) {
                TDataviewMap newEntity = new TDataviewMap();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e by param", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e Get TDataviewCategory By param")
    @GetMapping(value={"/detail"})
    public BaseResponse<TDataviewMap> getById(TDataviewMapParam param) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)param))) {
            QueryWrapper<TDataviewMap> queryWrapper = this.createQuery(param);
            TDataviewMap data = (TDataviewMap)((Object)this.tDataviewMapService.getOne((Wrapper)queryWrapper));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e ", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e Get TDataviewMap By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<TDataviewMap> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)id)) {
            TDataviewMap data = (TDataviewMap)((Object)this.tDataviewMapService.getById((Serializable)((Object)id)));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e ", notes="\u4fee\u6539 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e Update TDataviewMap By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TDataviewMap updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)updateRequest)) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            TDataviewMap data = (TDataviewMap)((Object)BeanHelper.beanToBean((Object)((Object)updateRequest), TDataviewMap.class));
            boolean result = this.tDataviewMapService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e ", notes="\u5220\u9664 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e delete TDataviewMap By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TDataviewMapDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            TDataviewMap data = new TDataviewMap();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.tDataviewMapService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e", notes="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e delete TDataviewMap by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody TDataviewMapDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<TDataviewMap> tDataviewMapList = new ArrayList<TDataviewMap>();
            for (String id : deleteRequest.getIds()) {
                TDataviewMap data = new TDataviewMap();
                data.setId(id);
                data.setStatus("1");
                tDataviewMapList.add(data);
            }
            boolean result = this.tDataviewMapService.updateBatchById(tDataviewMapList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e \u5206\u9875\u5217\u8868", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e \u5206\u9875\u5217\u8868 List TDataviewMap with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<TDataviewMap>> listEntity(TDataviewMapParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<TDataviewMap> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.tDataviewMapService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e \u5217\u8868", notes="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e \u5217\u8868 List TDataviewMap all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<TDataviewMap>> listAllEntity(TDataviewMapParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<TDataviewMap> queryWrapper = this.createQuery(param);
        List resultList = this.tDataviewMapService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<TDataviewMap> createQuery(TDataviewMapParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getName())) {
            queryWrapper.like((Object)"name", (Object)queryParam.getName());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getData())) {
            queryWrapper.eq((Object)"data", (Object)queryParam.getData());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

