package com.testor.common.core.domain;

import com.testor.common.core.enums.ApiStatusCodeEnum;
import com.testor.common.core.enums.HttpStatusCodeEnum;

public class ResponseInfo {
    private int code;
    private String msg;

    public static ResponseInfo transformApiStatus(ApiStatusCodeEnum apiStatusCodeEnum) {
        return builder().code(apiStatusCodeEnum.code()).msg(apiStatusCodeEnum.msg()).build();
    }

    public static ResponseInfo transformHttpStatus(HttpStatusCodeEnum httpStatusCodeEnum) {
        return builder().code(httpStatusCodeEnum.code()).msg(httpStatusCodeEnum.msg()).build();
    }

    public static ResponseInfoBuilder builder() {
        return new ResponseInfoBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(final int code) {
        this.code = code;
    }

    public void setMsg(final String msg) {
        this.msg = msg;
    }

    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof ResponseInfo)) {
            return false;
        } else {
            ResponseInfo other = (ResponseInfo)o;
            if (!other.canEqual(this)) {
                return false;
            } else if (this.getCode() != other.getCode()) {
                return false;
            } else {
                Object this$msg = this.getMsg();
                Object other$msg = other.getMsg();
                if (this$msg == null) {
                    if (other$msg != null) {
                        return false;
                    }
                } else if (!this$msg.equals(other$msg)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(final Object other) {
        return other instanceof ResponseInfo;
    }

    public String toString() {
        return "ResponseInfo(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }

    public ResponseInfo(final int code, final String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static class ResponseInfoBuilder {
        private int code;
        private String msg;

        ResponseInfoBuilder() {
        }

        public ResponseInfoBuilder code(final int code) {
            this.code = code;
            return this;
        }

        public ResponseInfoBuilder msg(final String msg) {
            this.msg = msg;
            return this;
        }

        public ResponseInfo build() {
            return new ResponseInfo(this.code, this.msg);
        }

        public String toString() {
            return "ResponseInfo.ResponseInfoBuilder(code=" + this.code + ", msg=" + this.msg + ")";
        }
    }
}