//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.kingbase8.jdbc;

import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

class BooleanTypeUtil {
    private BooleanTypeUtil() {
    }

    static boolean castToBoolean(Object in, String compatibleLevel) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Cast to boolean: \"{0}\"", new Object[]{String.valueOf(in)});
        }

        if (in instanceof Boolean) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return (Boolean)in;
        } else if (in instanceof String) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return fromString((String)in, compatibleLevel);
        } else if (in instanceof Character) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return fromCharacter((Character)in);
        } else if (in instanceof Number) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return fromNumber((Number)in, compatibleLevel);
        } else {
            throw new KSQLException("Cannot cast to boolean", KSQLState.CANNOT_COERCE);
        }
    }

    private static boolean fromString(String strvalue, String compatibleLevel) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String value = strvalue.trim();
        if (!"1".equals(value) && !"true".equalsIgnoreCase(value) && !"t".equalsIgnoreCase(value) && !"yes".equalsIgnoreCase(value) && !"y".equalsIgnoreCase(value) && !"on".equalsIgnoreCase(value)) {
            if (!"0".equals(value) && !"false".equalsIgnoreCase(value) && !"f".equalsIgnoreCase(value) && !"no".equalsIgnoreCase(value) && !"n".equalsIgnoreCase(value) && !"off".equalsIgnoreCase(value)) {
                double a;
                if (CompatibleDB.oracle(compatibleLevel)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    a = 0.0;

                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        a = Double.parseDouble(strvalue);
                    } catch (NumberFormatException var7) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw cannotCoerceException(strvalue);
                    }

                    if (a != 0.0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return true;
                    }

                    if (a == 0.0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return false;
                    }
                }

                if (CompatibleDB.mysql(compatibleLevel)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    a = 0.0;

                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
//                        a = Double.parseDouble(strvalue);
                        String hexString = strvalue;
                        if(strvalue.startsWith("0x")){

                            // 去掉字符串中的"0x"前缀，只保留十六进制数字部分
                            String hexValue = hexString.substring(2);

                            // 将十六进制字符串转换为整数
                            int intValue = Integer.parseInt(hexValue, 16);

                            a =  Double.valueOf(intValue);
                        } else {
                            a = Double.parseDouble(strvalue);
                        }

                    } catch (NumberFormatException var6) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw cannotCoerceException(strvalue);
                    }

                    if (a == 0.0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return false;
                    }

                    if (a == 1.0 || a == -1.0) {
                        return true;
                    }

                    if (a > 0.0) {
                        return true;
                    }

                    if (a < 0.0) {
                        return false;
                    }
                }

                throw cannotCoerceException(strvalue);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
    }

    private static boolean fromCharacter(Character charvalue) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ('1' != charvalue && 't' != charvalue && 'T' != charvalue && 'y' != charvalue && 'Y' != charvalue) {
            if ('0' != charvalue && 'f' != charvalue && 'F' != charvalue && 'n' != charvalue && 'N' != charvalue) {
                throw cannotCoerceException(charvalue);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
    }

    private static boolean fromNumber(Number numvalue, String compatibleLevel) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        double _value = numvalue.doubleValue();
        if (_value == 1.0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        } else if (_value == 0.0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        } else if (CompatibleDB.oracle(compatibleLevel) && _value != 0.0) {
            return true;
        } else {
            if (CompatibleDB.mysql(compatibleLevel)) {
                if (_value == -1.0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return true;
                }

                if (_value > 0.0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return true;
                }

                if (_value < 0.0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return false;
                }
            }

            throw cannotCoerceException(numvalue);
        }
    }

    private static KSQLException cannotCoerceException(Object _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Cannot cast to boolean: \"{0}\"", new Object[]{String.valueOf(_value)});
        }

        return new KSQLException(GT.tr("Cannot cast to boolean: \"{0}\"", new Object[]{String.valueOf(_value)}), KSQLState.CANNOT_COERCE);
    }

    public static void main(String[] args) {
        // 十六进制数值的字符串表示
        String hexString = "0x00";

        // 去掉字符串中的"0x"前缀，只保留十六进制数字部分
        String hexValue = hexString.substring(2);

        // 将十六进制字符串转换为整数
        int intValue = Integer.parseInt(hexValue, 16);

        // 将整数转换为double
        double doubleValue = (double) intValue;

        // 输出转换后的double数值
        System.out.println("The double value is: " + doubleValue);
    }
}
