package com.testor;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import com.testor.common.security.annotation.EnableRyFeignClients;
import com.tongtech.tfw.workflow.config.AppDispatcherServletConfiguration;
import com.tongtech.tfw.workflow.config.ApplicationConfiguration;
import com.tongtech.tfw.workflow.config.DatabaseAutoConfiguration;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.KingbaseDatabase;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableRyFeignClients
@EnableAsync
@SpringBootApplication(exclude = {DruidDataSourceAutoConfigure.class, ManagementWebSecurityAutoConfiguration.class, SecurityAutoConfiguration.class})
@MapperScan(basePackages = {"com.tongtech.**.**.dao", "com.testor.**.**.dao"})
@EnableSwagger2
@EnableKnife4j
@EnableScheduling
@ComponentScan(basePackages = {"com.tongtech", "com.testor"})
@Import(
        value = {
                // 引入修改的配置
                ApplicationConfiguration.class,
                AppDispatcherServletConfiguration.class,
                DatabaseAutoConfiguration.class
        })
public class StartupApplication {

    public static void main(String[] args) {

        DatabaseFactory.getInstance().register(new KingbaseDatabase());
        SpringApplication.run(StartupApplication.class, args);
    }
}
