package com.testor.common.constant;

import com.tongtech.tfw.backend.common.models.response.ResponseInfo;

public enum NewOrgEnumCode{
    ORG_LEVEL_NOT_GT_NINE(2007, "机构层级不能大于9层");

    private final int code;
    private final String msg;

    private NewOrgEnumCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int code() {
        return this.code;
    }

    public String msg() {
        return this.msg;
    }

    public ResponseInfo transform() {
        return ResponseInfo.builder().code(this.code()).msg(this.msg()).build();
    }
}
