package com.testor.common.translation.impl;

import com.testor.common.annotation.TranslationType;
import com.testor.common.constant.TransConstant;
import com.testor.common.translation.TranslationInterface;
import com.testor.module.sys.model.domian.NewSysOrg;
import com.testor.module.sys.service.NewSysOrgService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AllArgsConstructor
@TranslationType(type = TransConstant.ORG_ID_TO_NAME)
public class OrgIdTranslationImpl implements TranslationInterface<String> {

    @Autowired
    private NewSysOrgService newSysOrgService;

    @Override
    public String translation(Object key, String other) {
        NewSysOrg byId = newSysOrgService.getById(key.toString());
        if (byId != null) {
            return byId.getOrgName();
        }
        return "";
    }
}
