package com.testor.common.util;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/**
 * @author rsq
 * 签名前处理工具类
 * @program policy_query
 * @return
 **/
public class SignUtil {
    // 序列化data数据
    public static String serializeData(Map map){
        TreeMap treeMap = sortData(map);
        String serializeStr = "";
        Set set = treeMap.keySet();
        for (Object o : set) {
            serializeStr += o + "=" + treeMap.get(o) + "&";
        }
        return serializeStr;
    }

    // 排序data数据
    public static TreeMap sortData(Map map){
        TreeMap treeMap = new TreeMap(map);
        return treeMap;
    }

    public static void main(String[] args) {
        Date date = new Date();
        long time = date.getTime();
        System.out.println(time);
    }

    //超时时效，超过此时间认为签名过期 (1 min)
    private static long EXPIRE_TIME = 10 * 60 * 1000L;

    // 判断请求是否超时
    public static boolean verifyTimestamp(long timestamp){
        Date date = new Date();
        long time = date.getTime();

        long dif = time - timestamp;

        if(dif > -12000 && dif < EXPIRE_TIME){
            // 未过期
            return true;
        }else{
            // 请求过期
            return false;
        }
    }

}
