package com.testor.ddd.safetyControl.application.event;


import com.testor.ddd.safetyControl.application.service.riskSourceManage.RiskSourceRecordManageService;
import com.testor.ddd.safetyControl.domain.riskSource.entity.TSafeRiskSourceRepo;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTO;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 危险源操作记录
 */
@Aspect
@Component
public class RiskSourceOperRecordAspect {

    @Resource
    private TSafeRiskSourceRepo tSafeRiskSourceRepo;

    @Resource
    private RiskSourceRecordManageService riskSourceRecordManageService;

    @Pointcut("execution(* com.testor.ddd.safetyControl.infrastructure.repository.riskSource.service.TSafeRiskSourceServiceImpl.deleteById(..))")
    public void serviceDeleteByIdPointCut() {
    }

//    @Pointcut("execution(* com.testor.ddd.safetyControl.infrastructure.repository.riskSource.service.TSafeRiskSourceServiceImpl.deleteBySpaceOrEquipment(..))")
//    public void serviceDeleteBySpaceOrEquipmentByIdPointCut() {
//    }


    @Pointcut("execution(* com.testor.ddd.safetyControl.infrastructure.repository.riskSource.service.TSafeRiskSourceServiceImpl.insert(..))")
    public void serviceInsertPointCut() {
    }

    @Pointcut("execution(* com.testor.ddd.safetyControl.infrastructure.repository.riskSource.service.TSafeRiskSourceServiceImpl.updateById(..))")
    public void serviceUpdateByIdPointCut() {
    }

    @AfterReturning(value="serviceDeleteByIdPointCut()",returning="result")
    public void serviceDeleteByIdAfterReturning(JoinPoint joinPoint, Object result){

        try {
            Boolean bool = (Boolean) result;
            if(!bool) {
                return ;
            }
            Object[] args = joinPoint.getArgs();
            String sourceId = args[0].toString();

            riskSourceRecordManageService.editRiskSourceRecord(sourceId, 3);

        }catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @AfterReturning(value="serviceInsertPointCut()",returning="result")
    public void serviceInsertAfterReturning(JoinPoint joinPoint, Object result){

        try {
            TSafeRiskSourceDTO sourceDTO = (TSafeRiskSourceDTO) result;
            if(sourceDTO == null) {
                return ;
            }

            riskSourceRecordManageService.editRiskSourceRecord(sourceDTO.getId(), 1);


        }catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @AfterReturning(value="serviceUpdateByIdPointCut()",returning="result")
    public void serviceUpdateByIdAfterReturning(JoinPoint joinPoint, Object result){

        try {
            TSafeRiskSourceDTO sourceDTO = (TSafeRiskSourceDTO) result;
            if(sourceDTO == null) {
                return ;
            }

            riskSourceRecordManageService.editRiskSourceRecord(sourceDTO.getId(), 2);

        }catch (Throwable e) {
            e.printStackTrace();
        }
    }


}


