package com.testor.ddd.safetyControl.application.service.riskSourceManage;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.RiskSourceReportVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface RiskSourceManageService {
    /**
     * 编辑空间
     * @param RiskSourceOrgDto
     * @return
     */
    BaseResponse editRiskSource(TSafeRiskSourceDTO RiskSourceOrgDto) throws RuntimeException;

    BaseResponseList<TSafeRiskSourceVO> listByPage(TSafeRiskSourceDTOParam param);

    TSafeRiskSourceDTO findById(String id);

    BaseResponse deleteById(String id) throws RuntimeException;

    TSafeRiskSourceVO findDetailById(String id);

    /**
     * 列表不分页
     * @param param
     * @return
     */
    List<TSafeRiskSourceDTO> listAll(TSafeRiskSourceDTOParam param);

    /**
     *
     * @param type 1-设备; 2-空间(作业区域)；  3-空间(车间场所)；
     * @param bizId type=1-设备id; 2-空间(作业区域)id；  3-空间(车间场所)id；
     * @return
     */
    boolean deleteBySpaceOrEquipment(Integer type, String bizId);

    /**
     * 获取 导出危险源的 数据源
     *
     * @return
     */
    public List<RiskSourceReportVO> exportRiskData(String dsName, String datasetName, Map<String, Object> parameters);

//    /**
//     * 根据导入的excel中的编码 获取 对应 设备或空间信息
//     * @param code
//     * @return
//     */
//    Map<String, String> findEquipmentOrSpace(String code);

//    boolean saveBatch(List<TSafeRiskSourceDTO> riskSourceDTOList);

    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    boolean checkUniqueness(String orgId, String sourceId, String name);

    TSafeRiskSourceDTO save(TSafeRiskSourceDTO sourceDTO);

    // 查询指定空间 下的 最大 固有风险等级、现实风险等级
    Map findMaxRiskLevel(String spaceId, Integer level);

    /**
     * @description TODO 批量导出危险源台账
     * @param request
     * @param response
     * @param collect
     * @return void
     * @author qiao
     * @date 4/25/23 3:29 PM
     */
    void downloadFile(HttpServletRequest request, HttpServletResponse response, List<String> collect);

    /**
     * 批量导出危险源数据
     *
     * @param request
     * @param response
     * @param param
     */
    void exportRiskResource(HttpServletRequest request, HttpServletResponse response, TSafeRiskSourceDTOParam param);
}
