package com.testor.ddd.safetyControl.domain.equipment.entity;

import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import java.util.List;

/**
 *
 * 连接持久化的接口，具体实现类为 infrastructure.repository.impl
 *
 */
public interface TSafeEquipmentRepo {

    /**
     * 检测 名称、编码 是否都唯一
     * @param id
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    List<TSafeEquipmentDTO> checkUniqueness(String id, String equipmentTypeId, String name, String code);

    int insert(TSafeEquipmentDTO equipmentDTO);

    int updateById(TSafeEquipmentDTO equipmentDTO);
    /**
     * 设备分页查询
     * @param param
     * @return
     */
    BaseResponseList<TSafeEquipmentVO> listPage(TSafeEquipmentDTOParam param);

    TSafeEquipmentDTO findById(String id);

    /**
     * 查看设备详情
     * @param id
     * @return
     */
    TSafeEquipmentVO findDetailById(String id);

    boolean deleteBySpaceId(String id);

    Integer countEquipment(TSafeEquipmentDTOParam param);

    Integer replaceCode(String typeId, String oldCode, String newCode);

    List<TSafeEquipmentDTO> listAllEntity(TSafeEquipmentDTOParam param);

    boolean saveBatch(List<TSafeEquipmentDTO> equipmentDTOList);

    /**
     * 设备列表 （安全风险 拉下数据）
     * @param param
     * @return
     */
    List<TSafeEquipmentVO> listForRisk(TSafeEquipmentDTOParam param);

}
