package com.testor.ddd.safetyControl.domain.equipment.service;


import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.EquipmentStatisticsVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

/**
 * 设备Service接口
 * 
 * @author testor-framework
 * @date 2022-06-22 18:03:10
 */
public interface EquipmentService {
    /**
     * 检测 名称、编码 是否都唯一
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    boolean checkUniqueness(String id, String equipmentTypeId, String name, String code);

    /**
     * 编辑空间
     * @param equipmentOrgDto
     * @return
     */
    BaseResponse editEquipment(String userId, String orgId, TSafeEquipmentDTO equipmentOrgDto);

    BaseResponseList<TSafeEquipmentVO> listByPage(TSafeEquipmentDTOParam param);

    TSafeEquipmentDTO findById(String id);

    /**
     * 根据条件统计设备信息
     * @param orgId
     * @return
     */
    EquipmentStatisticsVO statisticsEquipment(String orgId);
}
