package com.testor.ddd.safetyControl.domain.riskMap.entity;

import com.testor.ddd.safetyControl.infrastructure.repository.riskMap.entity.TSafeRiskMapDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskMap.TSafeRiskMapVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 *
 * 连接持久化的接口，具体实现类为 infrastructure.repository.impl
 *
 */
public interface TSafeRiskMapRepo extends SuperService<TSafeRiskMapDO> {

    TSafeRiskMapDTO insert(TSafeRiskMapDTO riskMapDTO);

    TSafeRiskMapDTO updateById(TSafeRiskMapDTO riskMapDTO);

    /**
     * 分页查询
     * @param param
     * @return
     */
    BaseResponseList<TSafeRiskMapVO> listPage(TSafeRiskMapDTOParam param);

    TSafeRiskMapDTO findById(String id);

    boolean deleteById(String id);

    List<TSafeRiskMapDTO> listAllEntity(TSafeRiskMapDTOParam param);

    /**
     * 根据id查看详情
     * @param id
     * @return
     */
    TSafeRiskMapVO findDetailById(String id);

    /**
     * 列表不分页
     * @param param
     * @return
     */
    List<TSafeRiskMapDTO> listAll(TSafeRiskMapDTOParam param);


    /**
     * 检测 名称、编码 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    List<TSafeRiskMapDTO> checkUniqueness(String orgId, String sourceId, String name);

}
