package com.testor.ddd.safetyControl.infrastructure.client.funConfClient;

import com.testor.ddd.functionConfiguration.application.tableNum.TableNumManageService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class TableNumClientImpl implements  TableNumClient{

    @Resource
    private TableNumManageService tableNumManageService;
    public Integer obtainMaxNum(String tableName, String fieldName){
        return tableNumManageService.obtainMaxNum(tableName, fieldName);
    }

    /**
     * 修改保存 表、字段的当前最大值
     * @param tableName
     * @param fieldName
     * @param maxNum
     * @return
     */
    public BaseResponse saveMaxNum(String tableName, String fieldName, Integer maxNum){
        return tableNumManageService.saveMaxNum(tableName, fieldName, maxNum);
    }

    /**
     * 替换 匹配的fieldName
     * @param table
     * @param oldFieldName
     * @param newFieldName
     */
    public Integer replaceFieldName(String table, String oldFieldName, String newFieldName){
        return tableNumManageService.replaceFieldName( table, oldFieldName, newFieldName);
    }
}
