package com.testor.ddd.safetyControl.infrastructure.repository.equipment.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.domain.equipment.entity.TSafeEquipmentTypeRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.equipment.dao.TSafeEquipmentTypeDao;
import com.testor.ddd.safetyControl.infrastructure.repository.equipment.entity.TSafeEquipmentTypeDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentTypeVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 空间场所类型Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-02 11:02:04
 */
@Service
public class TSafeEquipmentTypeServiceImpl extends SuperServiceImpl<TSafeEquipmentTypeDao, TSafeEquipmentTypeDO> implements TSafeEquipmentTypeRepo
{
    @Autowired(required = false)
    private TSafeEquipmentTypeDao tSafeEquipmentTypeDao;
    @Override
    public List<TSafeEquipmentTypeDTO> checkUniqueness(String id, String name, String code) {
        LambdaQueryWrapper<TSafeEquipmentTypeDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TSafeEquipmentTypeDO::getStatus, BizConstants.STATUS_ENABLE)
                .and(wq -> wq
                        .eq(TSafeEquipmentTypeDO::getName, name)
                        .or()
                        .eq(TSafeEquipmentTypeDO::getCode,code));
        if(!StrUtil.isBlank(id)) {
            queryWrapper.ne(TSafeEquipmentTypeDO::getId, id);
        }
        List<TSafeEquipmentTypeDO> equipmentTypeDOList = tSafeEquipmentTypeDao.selectList(queryWrapper);
        List<TSafeEquipmentTypeDTO> equipmentTypeDTOList = BeanHelper.listToList(equipmentTypeDOList, TSafeEquipmentTypeDTO.class);
        return equipmentTypeDTOList;
    }

    public int insert(TSafeEquipmentTypeDTO equipmentTypeDTO){
        TSafeEquipmentTypeDO data = BeanHelper.beanToBean(equipmentTypeDTO, TSafeEquipmentTypeDO.class);
        return tSafeEquipmentTypeDao.insert(data);
    }

    public int updateById(TSafeEquipmentTypeDTO equipmentTypeDTO){
        TSafeEquipmentTypeDO data = BeanHelper.beanToBean(equipmentTypeDTO, TSafeEquipmentTypeDO.class);
        return tSafeEquipmentTypeDao.updateById(data);
    }

    public BaseResponseList<TSafeEquipmentTypeVO> listPage(TSafeEquipmentTypeDTOParam param){
        Long page=
                StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
        Long limit=
                StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
        Page<TSafeEquipmentTypeVO> resultPage = new Page<>(page, limit);
        IPage<TSafeEquipmentTypeVO> iPage = tSafeEquipmentTypeDao.listPage(resultPage, param);

        BaseResponseList<TSafeEquipmentTypeVO> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(iPage.getRecords());
        baseResponseList.setTotal(iPage.getTotal());
        return baseResponseList;
    }

    public TSafeEquipmentTypeDTO findById(String id){
        if(StrUtil.isBlank(id)) {
            return null;
        }
        TSafeEquipmentTypeDO equipmentTypeDo = tSafeEquipmentTypeDao.selectById(id);
        TSafeEquipmentTypeDTO equipmentTypeDTO = BeanHelper.beanToBean(equipmentTypeDo, TSafeEquipmentTypeDTO.class);
        return equipmentTypeDTO;
    }

    public boolean deleteById(String id){
        UpdateWrapper<TSafeEquipmentTypeDO> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().set(TSafeEquipmentTypeDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeEquipmentTypeDO::getStatus, BizConstants.STATUS_DELETE)
                .and(wq -> wq
                        .eq(TSafeEquipmentTypeDO::getId, id)
                        .or()
                        .eq(TSafeEquipmentTypeDO::getParentId,id));
        return update(updateWrapper);
    }

    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeEquipmentTypeDO> createQuery(TSafeEquipmentTypeDTOParam queryParam){
        QueryWrapper<TSafeEquipmentTypeDO> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getOrgId())){
            queryWrapper.eq(TSafeEquipmentTypeDO.ORG_ID,queryParam.getOrgId());
        }
        if(StringHelper.isNotEmpty(queryParam.getName())){
            queryWrapper.like(TSafeEquipmentTypeDO.NAME,queryParam.getName());
        }
        if(StringHelper.isNotEmpty(queryParam.getCode())){
            queryWrapper.eq(TSafeEquipmentTypeDO.CODE,queryParam.getCode());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeEquipmentTypeDO.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeEquipmentTypeDO.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSafeEquipmentTypeDO.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
