package com.testor.ddd.safetyControl.interfaces.controller;

import com.testor.ddd.safetyControl.application.service.riskStatistics.RiskStatisticsManageService;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskStatistics.RiskStatisticsDTO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskStatistics.RiskStatisticsNumVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 危险源Controller
 *
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@RestController
@RequestMapping("/risk/statistics")
@Api(value = "statistics", tags = "风险统计")
@Slf4j
public class RiskStatisticsController extends SuperController
{
    @Autowired
    private RiskStatisticsManageService riskSourceStatisticsManageService;


	@ApiOperation(value = "获取 危险源 数量统计")
	@PostMapping(value = "/statisticsNum")
	public  BaseResponse<List<RiskStatisticsNumVO>>statisticsNum(@RequestBody RiskStatisticsDTO param){
		BaseResponse<List<RiskStatisticsNumVO>>baseResponse=new BaseResponse<>();
		List<RiskStatisticsNumVO> resultList= riskSourceStatisticsManageService.statisticsSourceNum(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险源 数量统计(根据车间场所类型分组)")
	@PostMapping(value = "/statisticsNumBySpaceType")
	public  BaseResponse<List<RiskStatisticsNumVO>>statisticsNumBySpaceType(@RequestBody RiskStatisticsDTO param){
		BaseResponse<List<RiskStatisticsNumVO>>baseResponse=new BaseResponse<>();
		List<RiskStatisticsNumVO> resultList= riskSourceStatisticsManageService.statisticsSourceNumBySpaceType(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险源 等级统计")
	@PostMapping(value = "/statisticsSourceLevel")
	public  BaseResponse<List<RiskStatisticsNumVO>>statisticsSourceLevel(@RequestBody RiskStatisticsDTO param){
		BaseResponse<List<RiskStatisticsNumVO>>baseResponse=new BaseResponse<>();
		List<RiskStatisticsNumVO> resultList= riskSourceStatisticsManageService.statisticsSourceLevel(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险源 类型统计")
	@PostMapping(value = "/statisticsSourceType")
	public  BaseResponse<List<RiskStatisticsNumVO>>statisticsSourceType(@RequestBody RiskStatisticsDTO param){
		BaseResponse<List<RiskStatisticsNumVO>>baseResponse=new BaseResponse<>();
		List<RiskStatisticsNumVO> resultList= riskSourceStatisticsManageService.statisticsSourceType(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 风险点 数量统计")
	@PostMapping(value = "/statisticsPointNum")
	public  BaseResponse<List<RiskStatisticsNumVO>>statisticsPointNum(@RequestBody RiskStatisticsDTO param){
		BaseResponse<List<RiskStatisticsNumVO>>baseResponse=new BaseResponse<>();
		List<RiskStatisticsNumVO> resultList= riskSourceStatisticsManageService.statisticsPointNum(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 风险点 数量统计(根据车间场所类型分组)")
	@PostMapping(value = "/statisticsPointNumBySpaceType")
	public  BaseResponse<List<RiskStatisticsNumVO>>statisticsPointNumBySpaceType(@RequestBody RiskStatisticsDTO param){
		BaseResponse<List<RiskStatisticsNumVO>>baseResponse=new BaseResponse<>();
		List<RiskStatisticsNumVO> resultList= riskSourceStatisticsManageService.statisticsPointNumBySpaceType(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 风险点 等级统计")
	@PostMapping(value = "/statisticsPointLevel")
	public  BaseResponse<List<RiskStatisticsNumVO>>statisticsPointLevel(@RequestBody RiskStatisticsDTO param){
		BaseResponse<List<RiskStatisticsNumVO>>baseResponse=new BaseResponse<>();
		List<RiskStatisticsNumVO> resultList= riskSourceStatisticsManageService.statisticsPointLevel(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 风险点 类型统计")
	@PostMapping(value = "/statisticsPointType")
	public  BaseResponse<List<RiskStatisticsNumVO>>statisticsPointType(@RequestBody RiskStatisticsDTO param){
		BaseResponse<List<RiskStatisticsNumVO>>baseResponse=new BaseResponse<>();
		List<RiskStatisticsNumVO> resultList= riskSourceStatisticsManageService.statisticsPointType(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "导入危险源", notes = "")
	@PostMapping("/importRiskSource")
	public BaseResponse<String> importRiskSource(@RequestPart("file") MultipartFile file) throws Exception {
		return riskSourceStatisticsManageService.importRiskSource(file);
	}

	@ApiOperation(value = "导入风险点", notes = "")
	@PostMapping("/importRiskPoint")
	public BaseResponse<String> importRiskPoint(@RequestPart("file") MultipartFile file) throws Exception {
		return riskSourceStatisticsManageService.importRiskPoint(file);
	}
}
