package com.testor.ddd.safetyControl.interfaces.controller;

import com.testor.ddd.safetyControl.application.service.riskPointSource.RiskPointSourceManageService;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPointSource.TSafeRiskPointSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint.RiskPointSourceListVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint.RiskPointSourceVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 危险源Controller
 *
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@RestController
@RequestMapping("/risk/pointSource")
@Api(value = "TSafeRiskPoint", tags = "风险点危险源关联信息")
@Slf4j
public class TSafeRiskPointSourceController extends SuperController {
	@Autowired
	private RiskPointSourceManageService riskPointSourceManageService;

	@ApiOperation(value = "获取 风险点关联的危险源 列表", notes = "List TSafeRiskPoint with page")
	@PostMapping(value = "/listByPoint")
	public BaseResponse<List<RiskPointSourceVO>> listByPoint(@RequestBody TSafeRiskPointSourceDTOParam param) {
		BaseResponse<List<RiskPointSourceVO>> baseResponse = new BaseResponse<>();
		List<RiskPointSourceVO> list = riskPointSourceManageService.listByPoint(param);
		baseResponse.setData(list);
		return baseResponse;
	}

	@ApiOperation(value = "获取 可选危险源、 已选风险源、 禁选风险;  relationType 源关联类型(1-设备；2-空间)" +
			"				equipmentId, workshopId, workareaId: 根据实际的选择进行填写\n" +
			"     *              pointId： 新建时为空， 编辑时风险点id ")
	@PostMapping(value = "/listAll")
	public BaseResponse<RiskPointSourceListVO> listAll(@RequestBody TSafeRiskPointSourceDTOParam param) {
		BaseResponse<RiskPointSourceListVO> baseResponse = new BaseResponse<>();
		RiskPointSourceListVO listVO = riskPointSourceManageService.listAll(param);
		baseResponse.setData(listVO);
		return baseResponse;
	}
}