package com.testor.ddd.safetyControl.interfaces.controller;

import com.testor.ddd.safetyControl.application.service.spaceManage.SpaceTypeManageService;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;

/**
 * 空间场所类型Controller
 *
 * @author testor-framework
 * @date 2022-07-02 11:02:04
 */
@RestController
@RequestMapping("/space/spaceType")
@Api(value = "TSafeSpaceType", tags = "空间场所类型")
@Slf4j
public class TSafeSpaceTypeController extends SuperController
{
    @Autowired
    private SpaceTypeManageService spaceTypeManageService;

	/* Generated Method*/
	@ApiOperation(value = "新增、修改空间场所类型", notes = "Add TSafeSpace")
	@PostMapping(value = "/add")
	public BaseResponse addEntity(@RequestBody TSafeSpaceTypeDTO addRequest) {
		return spaceTypeManageService.editSpaceType(addRequest);
	}

	@ApiOperation(value = "删除 空间场所类型 ", notes = "delete TSafeSpace By Id")
	@PutMapping(value = "/delete")
	public BaseResponse deleteEntity(@RequestBody TSafeSpaceTypeDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&& StringHelper.isNotEmpty(deleteRequest.getId())){
			baseResponse= spaceTypeManageService.deleteById(deleteRequest.getId());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 空间场所类型 分页列表", notes = "List TSafeSpace with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSafeSpaceTypeDTO>>listEntity(TSafeSpaceTypeDTOParam param){
		BaseResponse<BaseResponseList<TSafeSpaceTypeDTO>>baseResponse=new BaseResponse<>();
		BaseResponseList<TSafeSpaceTypeDTO> resultList= spaceTypeManageService.listByPage(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}
}
