package com.testor.ddd.safetyControl.interfaces.model.dto.riskMap;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 风险地图 删除参数对象
 *
 * @author testor-framework
 * @date 2022-10-05 15:18:02
 */

@Data
@ApiModel(value = "TSafeRiskMap 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeRiskMapDTOParam extends TSafeRiskMapDTO {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	public String getLimit() {
		if(ObjectUtil.isEmpty(limit)){
			return "10";
		}
		return limit;
	}

	public String getPage() {
		if(ObjectUtil.isEmpty(page)){
			return "1";
		}

		return page;
	}
}
