package com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint;

import java.util.List;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskOwner.TSafeRiskOwnerDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPointSource.TSafeRiskPointSourceDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 危险点(风险分级)对象 t_safe_risk_point
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:14
 */
@Data
public class TSafeRiskPointDTO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  private String id;

  @ApiModelProperty(value = "组织结构完整路径(到部门)")
  private String orgAllPath;

/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")
  private String orgId;

  @ApiModelProperty(value = "区域公司id")
  private String regionOrgId;

/**
 * 部门id
 */
  @ApiModelProperty(value = "部门id(编辑必填)")
  private String departmentId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称(编辑必填)")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码")
  private String code;
/**
 * 风险类型(关联字典表id)
 */
  @ApiModelProperty(value = "风险类型(关联字典表id)(编辑必填)")
  private String typeId;
/**
 * 危险源关联类型(1-设备；2-空间)
 */
  @ApiModelProperty(value = "危险源关联类型(1-设备；2-空间)(编辑必填)" , example = "1")
  private Integer relationType;
/**
 * 关联设备id
 */
  @ApiModelProperty(value = "关联设备id")
  private String relationEquipmentId;
  /**
   * 关联空间id(作业区域)
   */
  @ApiModelProperty(value = "关联空间id(车间场所，作业区域父级)")
  private String relationSpaceParentId;
/**
 * 关联空间id(作业区域)
 */
  @ApiModelProperty(value = "关联空间id(作业区域)")
  private String relationSpaceId;
/**
 * 空间位置
 */
  @ApiModelProperty(value = "空间位置")
  private String spaceLocation;
/**
 * 固有风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "固有风险等级(关联字典表id)(编辑必填)")
  private String inherentLevelId;
/**
 * 现实风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "现实风险等级(关联字典表id)(编辑必填)")
  private String realLevelId;
/**
 * 管控层级(关联字典表id)
 */
  @ApiModelProperty(value = "管控层级(关联字典表id)(编辑必填)")
  private String controlLevelId;

  @ApiModelProperty(value = "关联空间层级ids")
  private String relationSpaceLevelIds;

  @ApiModelProperty(value = "关联设备层级ids")
  private String relationEquipmentLevelIds;

  @ApiModelProperty(value = "基层单位id")
  private String basicOrgId;

  @ApiModelProperty(value = "管控部门与责任人(编辑必填)")
  private List<TSafeRiskOwnerDTO> riskOwnerList;

  @ApiModelProperty(value = "关联危险源")
  private List<TSafeRiskPointSourceDTO> pointSourceList;
}
