package com.testor.ddd.safetyControl.interfaces.model.vo.riskSource;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 危险源对象 t_safe_risk_source_record
 * 
 * @author testor-framework
 * @date 2022-10-11 10:57:32
 */
@Data
public class TSafeRiskSourceRecordVO implements Serializable
{
  /**
   * id
   */
  @ApiModelProperty(value = "id")
  private String id;
  /**
   * 修改人所属组织机构id
   */
  @ApiModelProperty(value = "修改人所属组织机构id")
  private String orgId;
  /**
   * 修改人id
   */
  @ApiModelProperty(value = "修改人id")
  private String userId;
  /**
   * 危险源名称
   */
  @ApiModelProperty(value = "危险源名称")
  private String name;
  /**
   * 操作类型(1-新增；2-修改；3-删除)
   */
  @ApiModelProperty(value = "操作类型(1-新增；2-修改；3-删除)" , example = "0")
  private Integer operateType;
  /**
   * 危险源idid
   */
  @ApiModelProperty(value = "危险源idid")
  private String sourceId;

  @ApiModelProperty("创建时间")
  private String createDate;

  @ApiModelProperty("备注")
  private String remarks;

  @ApiModelProperty(value = "区域公司名称")
  private String regionOrgName;

  @ApiModelProperty(value = "组织机构(基层单位)")
  private String basicOrgName;

  @ApiModelProperty(value = "修改人名称")
  private String userName;

  @ApiModelProperty(value = "危险源名称")
  private String sourceName;

  @ApiModelProperty(value = "组织结构全路径名称")
  private String orgFullName;
}
