package com.testor.enums;

import com.baomidou.mybatisplus.annotation.DbType;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum DatabaseIdEnum {
    MYSQL("MySQL", "mysql", "com.mysql.cj.jdbc.Driver", DbType.MYSQL),
    KINGBASEESV8("KingbaseES", "kingbase", "com.kingbase8.Driver", DbType.KINGBASE_ES),
    DM("DM", "dm", "com.mysql.cj.jdbc.Driver", DbType.DM),
    GAUSS("Gauss", "gauss", "com.mysql.cj.jdbc.Driver", DbType.GAUSS),
    ORACLE("Oracle","oracle","oracle.jdbc.driver.OracleDriver", DbType.ORACLE);

    private final String type;
    private final String name;
    private final String driverClassName;
    private final DbType dbType;

    public static DatabaseIdEnum getDatabaseIdEnum(String type) {
        for (DatabaseIdEnum databaseIdEnum : DatabaseIdEnum.values()) {
            if (databaseIdEnum.getType().equals(type)) {
                return databaseIdEnum;
            }
        }
        return null;
    }

    public static DbType getDbTypeByDriver(String driverClassName){
        for (DatabaseIdEnum databaseIdEnum : DatabaseIdEnum.values()) {
            if (databaseIdEnum.getDriverClassName().equals(driverClassName)) {
                return databaseIdEnum.getDbType();
            }
        }
        return null;
    }
}
