package com.testor.module.ZLOA.sysOrgOA.controller;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.ZLOA.sysOrgOA.model.domain.TSysOrgOa;
import com.testor.module.ZLOA.sysOrgOA.model.dto.TSysOrgOaParam;
import com.testor.module.ZLOA.sysOrgOA.model.dto.TSysOrgOaDelParam;
import com.testor.module.ZLOA.sysOrgOA.service.TSysOrgOaService;

/**
 * 组织机构(OA)Controller
 *
 * @author testor-framework
 * @date 2022-09-13 09:57:13
 */
@RestController
@RequestMapping("/module/oa")
//@Api(value = "TSysOrgOa", tags = "组织机构(OA)")
@Slf4j
public class TSysOrgOaController extends SuperController
{
    @Autowired
    private TSysOrgOaService tSysOrgOaService;

    /* Generated Method*/
	@ApiOperation(value = "新增 组织机构(OA)", notes = "Add TSysOrgOa")
	@PostMapping(value = "/add")
	public BaseResponse<TSysOrgOa>addEntity(@RequestBody TSysOrgOa addRequest) {
		BaseResponse<TSysOrgOa> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TSysOrgOa data=BeanHelper.beanToBean(addRequest,  TSysOrgOa.class);
			data.setId(id);
			boolean result= tSysOrgOaService.save(data);
			if(result){
                TSysOrgOa newEntity = new TSysOrgOa();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 组织机构(OA) ", notes = "Get TSysOrgOa By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSysOrgOa> getById(String orgId){
		BaseResponse<TSysOrgOa> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(orgId)){
			// TODO 按需求添加业务异常判断
            TSysOrgOa data= tSysOrgOaService.getById(orgId);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 组织机构(OA) ", notes = "Update TSysOrgOa By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSysOrgOa updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSysOrgOa data=BeanHelper.beanToBean(updateRequest, TSysOrgOa.class);
			boolean result= tSysOrgOaService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 组织机构(OA) ", notes = "delete TSysOrgOa By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSysOrgOaDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSysOrgOa data= new TSysOrgOa();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tSysOrgOaService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除组织机构(OA)", notes = "delete TSysOrgOa by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TSysOrgOaDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TSysOrgOa> tSysOrgOaList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TSysOrgOa data= new TSysOrgOa();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tSysOrgOaList.add(data);
			}
			boolean result = tSysOrgOaService.updateBatchById(tSysOrgOaList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 组织机构(OA) 分页列表", notes = "List TSysOrgOa with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSysOrgOa>>listEntity(TSysOrgOaParam param){
		BaseResponse<BaseResponseList<TSysOrgOa>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TSysOrgOa> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSysOrgOa> queryWrapper=this.createQuery(param);
		Page<TSysOrgOa> resultList= tSysOrgOaService.page(resultPage,queryWrapper);
		BaseResponseList<TSysOrgOa> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 组织机构(OA) 列表", notes = "List TSysOrgOa all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TSysOrgOa>>listAllEntity(TSysOrgOaParam param){
		BaseResponse<BaseResponseList<TSysOrgOa>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSysOrgOa> queryWrapper=this.createQuery(param);
		List<TSysOrgOa> resultList=tSysOrgOaService.list(queryWrapper);
		BaseResponseList<TSysOrgOa> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TSysOrgOa> createQuery(TSysOrgOaParam queryParam){
		QueryWrapper<TSysOrgOa> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getParentId())){
			queryWrapper.eq(TSysOrgOa.PARENT_ID,queryParam.getParentId());
		}
		if(StringHelper.isNotEmpty(queryParam.getParentIds())){
			queryWrapper.eq(TSysOrgOa.PARENT_IDS,queryParam.getParentIds());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getTreeSort())){
			queryWrapper.eq(TSysOrgOa.TREE_SORT,queryParam.getTreeSort());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getTreeLevel())){
			queryWrapper.eq(TSysOrgOa.TREE_LEVEL,queryParam.getTreeLevel());
		}
		if(StringHelper.isNotEmpty(queryParam.getOrgName())){
			queryWrapper.like(TSysOrgOa.ORG_NAME,queryParam.getOrgName());
		}
		if(StringHelper.isNotEmpty(queryParam.getOrgCode())){
			queryWrapper.eq(TSysOrgOa.ORG_CODE,queryParam.getOrgCode());
		}
		if(StringHelper.isNotEmpty(queryParam.getAddress())){
			queryWrapper.eq(TSysOrgOa.ADDRESS,queryParam.getAddress());
		}
		if(StringHelper.isNotEmpty(queryParam.getZipCode())){
			queryWrapper.eq(TSysOrgOa.ZIP_CODE,queryParam.getZipCode());
		}
		if(StringHelper.isNotEmpty(queryParam.getLeader())){
			queryWrapper.eq(TSysOrgOa.LEADER,queryParam.getLeader());
		}
		if(StringHelper.isNotEmpty(queryParam.getPhoneNo())){
			queryWrapper.eq(TSysOrgOa.PHONE_NO,queryParam.getPhoneNo());
		}
		if(StringHelper.isNotEmpty(queryParam.getFax())){
			queryWrapper.eq(TSysOrgOa.FAX,queryParam.getFax());
		}
		if(StringHelper.isNotEmpty(queryParam.getEmail())){
			queryWrapper.eq(TSysOrgOa.EMAIL,queryParam.getEmail());
		}
		if(StringHelper.isNotEmpty(queryParam.getIsDept())){
			queryWrapper.eq(TSysOrgOa.IS_DEPT,queryParam.getIsDept());
		}
		if(StringHelper.isNotEmpty(queryParam.getProvince())){
			queryWrapper.eq(TSysOrgOa.PROVINCE,queryParam.getProvince());
		}
		if(StringHelper.isNotEmpty(queryParam.getCity())){
			queryWrapper.eq(TSysOrgOa.CITY,queryParam.getCity());
		}
		if(StringHelper.isNotEmpty(queryParam.getCounty())){
			queryWrapper.eq(TSysOrgOa.COUNTY,queryParam.getCounty());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TSysOrgOa.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TSysOrgOa.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TSysOrgOa.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
