package com.testor.module.accident.manager;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.accident.dao.AccidentPersonnelDao;
import com.testor.module.accident.model.domain.AccidentPersonnel;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 事故受伤人员Service业务层处理
 *
 * @author zhangyangfan@testor.com.cn
 * @date 2022-05-11 11:35:33
 */
@Service
public class AccidentPersonnelManager extends SuperServiceImpl<AccidentPersonnelDao, AccidentPersonnel> implements SuperService<AccidentPersonnel> {
    @Autowired(required = false)
    private AccidentPersonnelDao accidentPersonnelDao;

    public void deleteBatch(List<String> idList) {
        accidentPersonnelDao.deleteBatchIds(idList);
    }

    public void deleteByRefId(String refId) {
        LambdaQueryWrapper<AccidentPersonnel> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AccidentPersonnel::getRefId, refId);
        accidentPersonnelDao.delete(queryWrapper);
    }

}
