package com.testor.module.accident.model.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description: 事故excel导出列表
 * @date 2022/5/16 15:14
 */
@Service("accidentExport")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AccidentExport {

    public static final String EXCEL_ORIGINAL_FILE_NAME = "中粮贸易质量安全小事故信息统计表.xlsx";
    public static final String EXCEL_FILE_NAME = "中粮贸易质量安全小事故信息统计表";
    public static final String SUFFIX = ".xlsx";

    @ApiModelProperty("序号")
    @ExcelProperty(value = {"序号"}, index = 0)
    private int serialNumber;

    @ApiModelProperty("业务单位名称")
    @ExcelProperty(value = {"业务单位名称"}, index = 1)
    private String regionalCompanyName;

    @ApiModelProperty("基层企业名称")
    @ExcelProperty(value = {"基层企业名称"}, index = 2)
    private String basicUnitName;

    @ApiModelProperty("上报时间-年")
    @ExcelProperty(value = {"年"}, index = 3)
    private int reportTimeYear;

    @ApiModelProperty("上报时间-月")
    @ExcelProperty(value = {"月"}, index = 4)
    private int reportTimeMonth;

    @ApiModelProperty("上报时间-日")
    @ExcelProperty(value = {"日"}, index = 5)
    private int reportTimeDay;

    @ApiModelProperty("上报时间-时")
    @ExcelProperty(value = {"时"}, index = 6)
    private int reportTimeHour;

    @ApiModelProperty("是否节假日")
    @ExcelProperty(value = {"是否节假日"}, index = 7)
    private String fakeTypeName;

    @ApiModelProperty("受伤人员")
    @ExcelProperty(value = {"受伤人员"}, index = 8)
    private String name;

    @ApiModelProperty(value = "年龄", example = "0")
    @ExcelProperty(value = {"年龄"}, index = 9)
    private Long age;

    @ApiModelProperty(value = "性别")
    @ExcelProperty(value = {"性别"}, index = 10)
    private String gender;

    @ApiModelProperty(value = "归属类型（本单位、相关方）")
    @ExcelProperty(value = {"人员归属（相关方/本单位）"}, index = 11)
    private String belongTypeName;

    @ApiModelProperty(value = "小事故等级（轻事故/微事故/险兆事件）")
    @ExcelProperty(value = {"小事故等级（轻事故/微事故/险兆事件）"}, index = 12)
    private String accidentLevelName;

    @ApiModelProperty(value = "事故类型")
    @ExcelProperty(value = {"事故类型"}, index = 13)
    private String accidentTypeName;

    @ApiModelProperty(value = "经济损失——合计（万元）")
    @ExcelProperty(value = {"经济损失——合计（万元）"}, index = 14)
    private BigDecimal totalEconomicLoss;

    @ApiModelProperty(value = "经济损失——直接(万元）")
    @ExcelProperty(value = {"经济损失——直接(万元）"}, index = 15)
    private BigDecimal directEconomicLoss;

    @ApiModelProperty(value = "经济损失——间接（万元）")
    @ExcelProperty(value = {"经济损失——间接（万元）"}, index = 16)
    private BigDecimal indirectEconomicLoss;

    @ApiModelProperty(value = "事故经过简述")
    @ExcelProperty(value = {"事故经过简述"}, index = 17)
    private String accidentPassed;

    @ApiModelProperty(value = "事故原因（填写字母代号，多种原因以“/”分隔）")
    @ExcelProperty(value = {"事故原因（填写字母代号，多种原因以“/”分隔）"}, index = 18)
    private String accidentCause;

    @ApiModelProperty(value = "改善措施（及最佳实践★）")
    @ExcelProperty(value = {"改善措施（及最佳实践★）"}, index = 19)
    private String improvements;

    @ApiModelProperty(value = "备注")
    @ExcelProperty(value = {"备注"}, index = 20)
    private String remark;
}
