package com.testor.module.accident.model.excel;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;

/**
 * @title AccidentPersonnelVO
 * @description <TODO 受伤人员信息>
 * @Author: qiao
 * @version:1.0.0
 * @create：4/12/23 11:35 AM
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@ExcelTarget("AccidentInportVO")
public class AccidentPersonnelVO {

    @ApiModelProperty(value = "姓名", example = "0")
    @Excel(name = "姓名", width = 20)
    private String userName;

    @ApiModelProperty(value = "年龄", example = "0")
    @Excel(name = "年龄", width = 20)
    private Long age;

    @Excel(name = "人员归属", width = 20)
    private String belongTypeName;

    @Excel(name = "性别", width = 20)
    private String sexName;
}
