package com.testor.module.accident.model.resp;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description: 事故上报列表查询响应
 * @date 2022/5/11 16:48
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "事故上报列表查询响应", description = "")
public class AccidentReportQueryResp {

    @ApiModelProperty(value = "主键id")
    private String id;

    @ApiModelProperty(value = "区域公司")
    private String regionalCompanyName;

    @ApiModelProperty(value = "基层单位")
    private String basicUnitName;

    @ApiModelProperty(value = "事故等级")
    private String accidentLevelName;

    @ApiModelProperty(value = "事故类型")
    private String accidentTypeName;

    @ApiModelProperty(value = "事故时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date accidentTime;

    @ApiModelProperty(value = "审核状态")
    private String processStatusName;

    @ApiModelProperty(value = "第三层单位")
    private String thirdLevelUnitId;

    @ApiModelProperty(value = "第三层单位")
    private String thirdLevelUnit;

    @ApiModelProperty(value = "单位全路径")
    private String fullDept;
}
