package com.testor.module.appUpdate.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
@Data
@Accessors(chain = true)
@TableName("t_sys_app_package")
@ApiModel(value = "TSysAppPackage", description = "")
public class TSysAppPackage {

    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    /**
     * 版本号
     */
    @ApiModelProperty(value = "版本号")
    @TableField("version")
    private String version;

    /**
     * 下载链接
     */
    @ApiModelProperty(value = "下载链接")
    @TableField("url")
    private String url;

    /**
     * 是否强制更新
     */
    @ApiModelProperty(value = "是否强制更新  1强制;2不强制")
    @TableField("is_mandatory")
    private String isMndatory;

    /**
     * 更新平台 字典值 code：PLATFORM
     */
    @ApiModelProperty(value = "更新平台 字典值 code：PLATFORM")
    @TableField("platform")
    private String platform;

    /**
     * 标题
     */
    @ApiModelProperty(value = "标题")
    @TableField("title")
    private String title;

    /**
     * 1:全量；2:热更新
     */
    @ApiModelProperty(value = "1:全量；2:热更新")
    @TableField("type")
    private String type;

    /**
     * 内容
     */
    @ApiModelProperty(value = "内容")
    @TableField("content")
    private String content;


}
