package com.testor.module.contractor.common.controller;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.common.model.domain.TContractorLedgerProject;
import com.testor.module.contractor.common.model.dto.TContractorLedgerProjectParam;
import com.testor.module.contractor.ledger.model.dto.TContractorLedgerProjectDelParam;
import com.testor.module.contractor.common.service.TContractorLedgerProjectService;

/**
 * 承包商台账和项目台账关系Controller
 *
 * @author testor-framework
 * @date 2024-11-20 20:50:55
 */
@RestController
@RequestMapping("/contractor/contractorAndProject")
@Api(value = "TContractorLedgerProject", tags = "承包商台账和项目台账关系")
@Slf4j
public class TContractorLedgerProjectController extends SuperController
{
    @Autowired
    private TContractorLedgerProjectService tContractorLedgerProjectService;

    /* Generated Method*/
	@ApiOperation(value = "新增 承包商台账和项目台账关系", notes = "Add TContractorLedgerProject")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorLedgerProject>addEntity(@RequestBody TContractorLedgerProject addRequest) {
		BaseResponse<TContractorLedgerProject> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorLedgerProject data=BeanHelper.beanToBean(addRequest,  TContractorLedgerProject.class);
			data.setId(id);
			boolean result= tContractorLedgerProjectService.save(data);
			if(result){
                TContractorLedgerProject newEntity = new TContractorLedgerProject();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商台账和项目台账关系 ", notes = "Get TContractorLedgerProject By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorLedgerProject> getById(String id){
		BaseResponse<TContractorLedgerProject> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorLedgerProject data= tContractorLedgerProjectService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 承包商台账和项目台账关系 ", notes = "Update TContractorLedgerProject By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorLedgerProject updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorLedgerProject data=BeanHelper.beanToBean(updateRequest, TContractorLedgerProject.class);
			boolean result= tContractorLedgerProjectService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 承包商台账和项目台账关系 ", notes = "delete TContractorLedgerProject By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorLedgerProjectDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorLedgerProject data= new TContractorLedgerProject();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorLedgerProjectService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除承包商台账和项目台账关系", notes = "delete TContractorLedgerProject by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorLedgerProjectDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorLedgerProject> tContractorLedgerProjectList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorLedgerProject data= new TContractorLedgerProject();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorLedgerProjectList.add(data);
			}
			boolean result = tContractorLedgerProjectService.updateBatchById(tContractorLedgerProjectList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商台账和项目台账关系 分页列表", notes = "List TContractorLedgerProject with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorLedgerProject>>listEntity(TContractorLedgerProjectParam param){
		BaseResponse<BaseResponseList<TContractorLedgerProject>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorLedgerProject> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorLedgerProject> queryWrapper=this.createQuery(param);
		Page<TContractorLedgerProject> resultList= tContractorLedgerProjectService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorLedgerProject> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商台账和项目台账关系 列表", notes = "List TContractorLedgerProject all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorLedgerProject>>listAllEntity(TContractorLedgerProjectParam param){
		BaseResponse<BaseResponseList<TContractorLedgerProject>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorLedgerProject> queryWrapper=this.createQuery(param);
		List<TContractorLedgerProject> resultList=tContractorLedgerProjectService.list(queryWrapper);
		BaseResponseList<TContractorLedgerProject> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorLedgerProject> createQuery(TContractorLedgerProjectParam queryParam){
		QueryWrapper<TContractorLedgerProject> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getContractorId())){
			queryWrapper.eq(TContractorLedgerProject.CONTRACTOR_ID,queryParam.getContractorId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProjectId())){
			queryWrapper.eq(TContractorLedgerProject.PROJECT_ID,queryParam.getProjectId());
		}
		if(StringHelper.isNotEmpty(queryParam.getBizId())){
			queryWrapper.eq(TContractorLedgerProject.BIZ_ID,queryParam.getBizId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorLedgerProject.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorLedgerProject.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorLedgerProject.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
