package com.testor.module.contractor.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.contractor.common.dao.TContractorLedgerProjectDao;
import com.testor.module.contractor.common.model.domain.TContractorLedgerProject;
import com.testor.module.contractor.common.service.TContractorLedgerProjectService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 承包商台账和项目台账关系Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-20 20:50:55
 */
@Service
public class TContractorLedgerProjectServiceImpl extends SuperServiceImpl<TContractorLedgerProjectDao, TContractorLedgerProject> implements TContractorLedgerProjectService
{
    @Autowired(required = false)
    private TContractorLedgerProjectDao tContractorLedgerProjectDao;

    @Override
    public List<String> getProjIdsByBizId(String bizId) {
        List<TContractorLedgerProject> tContractorLedgerProjects = this.list(new LambdaQueryWrapper<TContractorLedgerProject>().eq(TContractorLedgerProject::getBizId, bizId));
        //获取集合里projectId
        return tContractorLedgerProjects.stream().map(TContractorLedgerProject::getProjectId).collect(Collectors.toList());
    }
}
