package com.testor.module.contractor.ledger.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.common.core.utils.StringUtils;
import com.testor.common.excel.ExcelResult;
import com.testor.common.util.excel.EasyExcelUtil;
import com.testor.module.contractor.ledger.model.domain.TContractorProtectiveEquipment;
import com.testor.module.contractor.ledger.model.dto.TContractorProtectiveEquipmentDelParam;
import com.testor.module.contractor.ledger.model.dto.TContractorProtectiveEquipmentParam;
import com.testor.module.contractor.ledger.model.template.ProtectiveEquipmentTemplate;
import com.testor.module.contractor.ledger.model.template.ToolsTemplate;
import com.testor.module.contractor.ledger.service.TContractorProtectiveEquipmentService;
import com.testor.module.sys.service.NewSysDictDataService;
import com.testor.module.sys.service.NewSysOrgService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 防护用品台账Controller
 *
 * @author testor-framework
 * @date 2024-11-21 11:14:16
 */
@RestController
@RequestMapping("/contractor/protectiveEquipment")
@Api(value = "TContractorProtectiveEquipment", tags = "防护用品台账")
@Slf4j
public class TContractorProtectiveEquipmentController extends SuperController
{
    @Autowired
    private TContractorProtectiveEquipmentService tContractorProtectiveEquipmentService;

	@Autowired
	private NewSysDictDataService newSysDictDataService;

    /* Generated Method*/
	@ApiOperation(value = "新增 防护用品台账", notes = "Add TContractorProtectiveEquipment")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorProtectiveEquipment>addEntity(@RequestBody TContractorProtectiveEquipment addRequest) {
		BaseResponse<TContractorProtectiveEquipment> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorProtectiveEquipment data=BeanHelper.beanToBean(addRequest,  TContractorProtectiveEquipment.class);
			data.setId(id);
			UserInfo loginUser = ContextUtils.getLoginUser();
			data.setOrgId(loginUser.getOrgId());
			boolean result= tContractorProtectiveEquipmentService.save(data);
			if(result){
                TContractorProtectiveEquipment newEntity = new TContractorProtectiveEquipment();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 防护用品台账 ", notes = "Get TContractorProtectiveEquipment By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorProtectiveEquipment> getById(String id){
		BaseResponse<TContractorProtectiveEquipment> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorProtectiveEquipment data= tContractorProtectiveEquipmentService.getById(id);

			// 设置防护用品名称下拉框值，默认为“防护用品名称name”，当防护用品名称name值不在“承包商管理-防护用品台账-名称”字典表中时，设置为“其他”
			String dictId = newSysDictDataService.getDictId("contractor_protective_equipment_name",data.getName(),null);
			String nameSelect = data.getName();
			if(StringUtils.isBlank(dictId)){
				nameSelect = "其他";
			}
			data.setNameSelect(nameSelect);

			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 防护用品台账 ", notes = "Update TContractorProtectiveEquipment By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorProtectiveEquipment updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorProtectiveEquipment data=BeanHelper.beanToBean(updateRequest, TContractorProtectiveEquipment.class);
			boolean result= tContractorProtectiveEquipmentService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 防护用品台账 ", notes = "delete TContractorProtectiveEquipment By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorProtectiveEquipmentDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorProtectiveEquipment data= new TContractorProtectiveEquipment();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorProtectiveEquipmentService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除防护用品台账", notes = "delete TContractorProtectiveEquipment by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorProtectiveEquipmentDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorProtectiveEquipment> tContractorProtectiveEquipmentList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorProtectiveEquipment data= new TContractorProtectiveEquipment();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorProtectiveEquipmentList.add(data);
			}
			boolean result = tContractorProtectiveEquipmentService.updateBatchById(tContractorProtectiveEquipmentList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 防护用品台账 分页列表", notes = "List TContractorProtectiveEquipment with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorProtectiveEquipment>>listEntity(TContractorProtectiveEquipmentParam param){
		BaseResponse<BaseResponseList<TContractorProtectiveEquipment>>baseResponse=new BaseResponse<>();
		Page<TContractorProtectiveEquipment> resultList= tContractorProtectiveEquipmentService.listEntity(param);
		BaseResponseList<TContractorProtectiveEquipment> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 防护用品台账 列表", notes = "List TContractorProtectiveEquipment all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorProtectiveEquipment>>listAllEntity(TContractorProtectiveEquipmentParam param){
		BaseResponse<BaseResponseList<TContractorProtectiveEquipment>>baseResponse=new BaseResponse<>();
		List<TContractorProtectiveEquipment> resultList=tContractorProtectiveEquipmentService.listAllEntity(param);
		BaseResponseList<TContractorProtectiveEquipment> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "下载 承包商管理-防护用品台账 导入模板", notes = "Download TContractorProtectiveEquipment import template")
	@GetMapping(value = "/importTemplate")
	public void importTemplate (HttpServletResponse response, String fileDowName) throws Exception {
		List<ProtectiveEquipmentTemplate> templates = new ArrayList<>();
		templates.add(new ProtectiveEquipmentTemplate());
		EasyExcelUtil.writeExcelBySelect(response,"应急物资台账导入模板","应急物资台账",templates);
	}

	@ApiOperation(value = "导入 承包商管理-防护用品台账 ", notes = "Import TContractorProtectiveEquipment")
	@PostMapping(value = "/importProtectiveEquipmentLedger")
	public BaseResponse<String> importProtectiveEquipmentLedger(@RequestParam("file") MultipartFile file) throws Exception{
		BaseResponse<String>  baseResponse = new BaseResponse<>();
		// 导入Excel文件，将文件流转换为 ProtectiveEquipmentTemplate 对象列表
		ExcelResult<ProtectiveEquipmentTemplate> protectiveEquipmentTemplateExcelResult = EasyExcelUtil.importExcel(file.getInputStream(), ProtectiveEquipmentTemplate.class, true);
		// 获取 ProtectiveEquipmentTemplate 对象列表
		List<ProtectiveEquipmentTemplate> list = protectiveEquipmentTemplateExcelResult.getList();

		List<TContractorProtectiveEquipment> dataList = BeanHelper.listToList(list, TContractorProtectiveEquipment.class);
		UserInfo userInfo = ContextUtils.getLoginUser();
		for(TContractorProtectiveEquipment data:dataList){
			data.setOrgId(userInfo.getOrgId());
		}
		tContractorProtectiveEquipmentService.saveBatch(dataList);

		return baseResponse;
	}

    /* Private Methods */

}
