package com.testor.module.contractor.ledger.model.domain;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.annotation.TranslationType;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 承包商台账对象 t_contractor_ledger
 * 
 * @author testor-framework
 * @date 2024-11-19 10:01:42
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_ledger")
@ApiModel(value = "TContractorLedger对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorLedger extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 承包商名称
 */
  @ApiModelProperty(value = "承包商信息")

  @TableField("info_id")
  private String infoId;

  /**
   * 承包商名称
   */
  @ApiModelProperty("承包商信息")
  @TableField(exist = false)
  private TContractorInfo tContractorInfo;

/**
 * 承包商类型id（字典表id）
 */
  @ApiModelProperty(value = "承包商类型id（字典表id）")

  @TableField("type_id")
  private String typeId;
/**
 * 承包商类型
 */
  @ApiModelProperty(value = "承包商类型")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "typeId")
  @TableField("type")
  private String type;
/**
 * 业务性质id（字典表id）
 */
  @ApiModelProperty(value = "业务性质id（字典表id）")

  @TableField("biz_nature_id")
  private String bizNatureId;

/**
 * 业务性质
 */
  @ApiModelProperty(value = "业务性质")

  @TableField("biz_nature")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "bizNatureId")
  private String bizNature;

/**
 * 承包商安全负责人
 */
  @ApiModelProperty(value = "承包商安全负责人")

  @TableField("safety_official")
  private String safetyOfficial;
/**
 * 承包商安全负责人电话
 */
  @ApiModelProperty(value = "承包商安全负责人电话")

  @TableField("safety_official_tel")
  private String safetyOfficialTel;
/**
 * 承包商技术负责人
 */
  @ApiModelProperty(value = "承包商技术负责人")

  @TableField("tech_leader")
  private String techLeader;
/**
 * 承包商技术负责人电话
 */
  @ApiModelProperty(value = "承包商技术负责人电话")

  @TableField("tech_leader_tel")
  private String techLeaderTel;
/**
 * 所属企业id
 */
  @ApiModelProperty(value = "所属企业id")

  @TableField("org_id")
  private String orgId;

  @TableField(exist = false)
  private String orgName;

/**
 * 安全生产许可证，存文件id
 */
  @ApiModelProperty(value = "安全生产许可证，存文件id")

  @TableField("safety_prod_license")
  private String safetyProdLicense;

  /**
   * 安全生产许可证，存文件url
   */
  @TableField(exist = false)
  @Translation(type = TransConstant.FILE_ID_TO_URL,mapper = "safetyProdLicense")
  private String safetyProdLicenseUrl;

/**
 * 安全生产管理协议，存文件id
 */
  @ApiModelProperty(value = "安全生产管理协议，存文件id")

  @TableField("safety_prod_agreement")
  private String safetyProdAgreement;
/**
 * 营业执照、资质证照，存文件id
 */
  @ApiModelProperty(value = "营业执照、资质证照，存文件id")

  @TableField("license")
  private String license;

  @TableField(exist = false)
  @Translation(type = TransConstant.FILE_ID_TO_URL,mapper = "license")
  private String licenseUrl;

/**
 * 近三年无事故证明，存文件id
 */
  @ApiModelProperty(value = "近三年无事故证明，存文件id")

  @TableField("accident_free_record")
  private String accidentFreeRecord;
/**
 * 承包商公司相关管理制度，存文件id
 */
  @ApiModelProperty(value = "承包商公司相关管理制度，存文件id")

  @TableField("man_policies")
  private String manPolicies;

  public static final String ID ="id";
  public static final String NAME ="name";
  public static final String CREDIT_CODE ="credit_code";
  public static final String TYPE_ID ="type_id";
  public static final String INFO_ID ="info_id";
  public static final String TYPE ="type";
  public static final String BIZ_NATURE_ID ="biz_nature_id";
  public static final String BIZ_NATURE ="biz_nature";
  public static final String REG_CAPITAL ="reg_capital";
  public static final String PROVINCE ="province";
  public static final String CITY ="city";
  public static final String ADDR ="addr";
  public static final String LEGAL_PERSON ="legal_person";
  public static final String TEL ="tel";
  public static final String REG_DATE ="reg_date";
  public static final String VALID_PERIOD ="valid_period";
  public static final String BIZ_SCOPE ="biz_scope";
  public static final String SAFETY_OFFICIAL ="safety_official";
  public static final String SAFETY_OFFICIAL_TEL ="safety_official_tel";
  public static final String TECH_LEADER ="tech_leader";
  public static final String TECH_LEADER_TEL ="tech_leader_tel";
  public static final String ORG_ID ="org_id";
  public static final String SAFETY_PROD_LICENSE ="safety_prod_license";
  public static final String SAFETY_PROD_AGREEMENT ="safety_prod_agreement";
  public static final String LICENSE ="license";
  public static final String ACCIDENT_FREE_RECORD ="accident_free_record";
  public static final String MAN_POLICIES ="man_policies";


}
