package com.testor.module.contractor.ledger.model.template;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.baomidou.mybatisplus.annotation.TableField;
import com.testor.common.annotation.ExcelDictFormat;
import com.testor.common.annotation.ExcelSelected;
import com.testor.common.constant.ExcelSelectConstant;
import com.testor.common.convert.ExcelDictConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 防护用品台账导入模板
 */

@Data
public class ProtectiveEquipmentTemplate {
    /**
     * 防护用品名称
     */
    @ExcelProperty(value = "防护用品名称", index = 0)
    @NotBlank(message = "防护用品名称不能为空")
    @ColumnWidth(value = 20)
    private String name;

    /**
     * 类别id（数据字典id）
     */
    @ExcelProperty(value = "类别",converter = ExcelDictConvert.class,index = 1)
    @ExcelDictFormat(dictType = "contractor_protective_equipment_type")
    @ExcelSelected(type = ExcelSelectConstant.DICT_DATA_BY_TYPE, param = "contractor_protective_equipment_type")
    @NotBlank(message = "类别不能为空")
    @ColumnWidth(value = 20)
    private String typeId;

    /**
     * 常规用品 0否 1是
     */
    @ExcelProperty(value = "常规用品",converter = ExcelDictConvert.class,index = 2)
    @ExcelSelected(source = {"否", "是"})
    @ExcelDictFormat(readConverterExp = "0=否,1=是")
    @NotBlank(message = "常规用品不能为空")
    @ColumnWidth(value = 20)
    private String isGeneral;
    /**
     * 型号
     */
    @ExcelProperty(value = "型号",index = 3)
    @NotBlank(message = "型号不能为空")
    @ColumnWidth(value = 20)
    private String model;
    /**
     * 数量
     */
    @ExcelProperty(value = "数量",index = 4)
    @NotNull(message = "数量不能为空")
    @Min(value = 1,message = "数量不能小于1")
    @Max(value = 99999L,message = "数量不能大于99999")
    @ColumnWidth(value = 20)
    private Long num;
    /**
     * 用途
     */
    @ExcelProperty(value = "用途",index = 5)
    @NotBlank(message = "用途不能为空")
    @ColumnWidth(value = 20)
    private String purpose;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注",index = 6)
    @ColumnWidth(value = 20)
    private String remarks;
}
