package com.testor.module.contractor.ledger.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.dao.TContractorProtectiveEquipmentDao;
import com.testor.module.contractor.ledger.model.domain.TContractorProtectiveEquipment;
import com.testor.module.contractor.ledger.model.dto.TContractorProtectiveEquipmentParam;
import com.testor.module.contractor.ledger.service.TContractorProtectiveEquipmentService;
import com.testor.module.sys.service.NewSysOrgService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

/**
 * 防护用品台账Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-21 11:14:16
 */
@Service
public class TContractorProtectiveEquipmentServiceImpl extends SuperServiceImpl<TContractorProtectiveEquipmentDao, TContractorProtectiveEquipment> implements TContractorProtectiveEquipmentService
{
    @Autowired(required = false)
    private TContractorProtectiveEquipmentDao tContractorProtectiveEquipmentDao;

    @Autowired
    private NewSysOrgService newSysOrgService;

    @Override
    public Page<TContractorProtectiveEquipment> listEntity(TContractorProtectiveEquipmentParam param) {
        Long page=
                StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
        Long limit=
                StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
        Page<TContractorProtectiveEquipment> resultPage=new Page<>(page,limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TContractorProtectiveEquipment> queryWrapper=this.createQuery(param);
        return this.page(resultPage,queryWrapper);
    }

    @Override
    public List<TContractorProtectiveEquipment> listAllEntity(TContractorProtectiveEquipmentParam param) {
        QueryWrapper<TContractorProtectiveEquipment> queryWrapper=this.createQuery(param);
        return this.list(queryWrapper);
    }

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContractorProtectiveEquipment> createQuery(TContractorProtectiveEquipmentParam queryParam){
        QueryWrapper<TContractorProtectiveEquipment> queryWrapper=new QueryWrapper<>();
        UserInfo loginUser = ContextUtils.getLoginUser();
        String orgId = loginUser.getOrgId();
        List<String> idsChildrenById = newSysOrgService.getIdsChildrenById(orgId);
        //查询下级机构id
        queryWrapper.in("org_id", idsChildrenById);
        if (ObjectHelper.isNotEmpty(queryParam.getIds())) {
            if ("0".equals(queryParam.getTypeQuery())){
                queryWrapper.notIn("id", queryParam.getIds());
            }else {
                queryWrapper.in("id", queryParam.getIds());
            }
        }
        if(StringHelper.isNotEmpty(queryParam.getName())){
            queryWrapper.like(TContractorProtectiveEquipment.NAME,queryParam.getName());
        }
        if(StringHelper.isNotEmpty(queryParam.getTypeId())){
            queryWrapper.eq(TContractorProtectiveEquipment.TYPE_ID,queryParam.getTypeId());
        }
        if(StringHelper.isNotEmpty(queryParam.getType())){
            queryWrapper.eq(TContractorProtectiveEquipment.TYPE,queryParam.getType());
        }
        if(StringHelper.isNotEmpty(queryParam.getIsGeneral())){
            queryWrapper.eq(TContractorProtectiveEquipment.IS_GENERAL,queryParam.getIsGeneral());
        }
        if(StringHelper.isNotEmpty(queryParam.getModel())){
            queryWrapper.eq(TContractorProtectiveEquipment.MODEL,queryParam.getModel());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getNum())){
            queryWrapper.eq(TContractorProtectiveEquipment.NUM,queryParam.getNum());
        }
        if(StringHelper.isNotEmpty(queryParam.getPurpose())){
            queryWrapper.eq(TContractorProtectiveEquipment.PURPOSE,queryParam.getPurpose());
        }
        if(StringHelper.isNotEmpty(queryParam.getOrgId())){
            queryWrapper.eq(TContractorProtectiveEquipment.ORG_ID,queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContractorProtectiveEquipment.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContractorProtectiveEquipment.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TContractorProtectiveEquipment.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
