package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 承包商管理-验收交付对象 t_contractor_acceptance
 * 
 * @author testor-framework
 * @date 2024-12-01 15:01:41
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_acceptance")
@ApiModel(value = "TContractorAcceptance对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorAcceptance extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 承包商台账id
 */
  @ApiModelProperty(value = "承包商台账id")

  @TableField("contractor_id")
  private String contractorId;
/**
 * 项目id
 */
  @ApiModelProperty(value = "项目id")

  @TableField("proj_id")
  private String projId;
/**
 * 业务id(标识是一条基本信息产生的关系)
 */
  @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

  @TableField("biz_id")
  private String bizId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;

  @TableField(exist = false)
  @Translation(type = TransConstant.DICT_TYPE_TO_LABEL,other = "contractor_process_status",mapper = "processStatus")
  private String processStatusName;

/**
 * 项目主管部门
 */
  @ApiModelProperty(value = "项目主管部门")

  @TableField("department_major")
  private String departmentMajor;
/**
 * 作业单位(项目所在部门)
 */
  @ApiModelProperty(value = "作业单位(项目所在部门)")

  @TableField("department_belong")
  private String departmentBelong;
/**
 * 竣工日期
 */
  @ApiModelProperty(value = "竣工日期")

  @TableField("finish_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date finishDate;
/**
 * 组织id
 */
  @ApiModelProperty(value = "组织id")

  @TableField("org_id")
  private String orgId;

  public static final String ID ="id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String PROJ_ID ="proj_id";
  public static final String BIZ_ID ="biz_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String DEPARTMENT_MAJOR ="department_major";
  public static final String DEPARTMENT_BELONG ="department_belong";
  public static final String FINISH_DATE ="finish_date";
  public static final String ORG_ID ="org_id";


}
