package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;

import com.testor.common.annotation.Translation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 日常管理-每日工作计划-工作内容对象 t_contractor_daily_plan_content
 * 
 * @author testor-framework
 * @date 2024-11-28 15:40:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_daily_plan_content")
@ApiModel(value = "TContractorDailyPlanContent对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorDailyPlanContent extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 日常工作计划id
 */
  @ApiModelProperty(value = "日常工作计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 类型
 */
  @ApiModelProperty(value = "类型(0=特殊作业管理 1=安全技术管理)")

  @TableField("type")
  private String type;

  /**
   * 分类
   */
  @ApiModelProperty(value = "分类")

  @TableField("category")
  private String category;


/**
 * 工作内容
 */
  @ApiModelProperty(value = "工作内容")

  @TableField("work_content")
  private String workContent;
/**
 * 是否涉及
 */
  @ApiModelProperty(value = "是否涉及")

  @TableField("if_involve")
  private String ifInvolve;
/**
 * 具体内容
 */
  @ApiModelProperty(value = "具体内容")

  @TableField("content")
  private String content;
/**
 * 编号
 */
  @ApiModelProperty(value = "编号" , example = "0")

  @TableField("sort_no")
  private Long sortNo;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String TYPE ="type";
  public static final String WORK_CONTENT ="work_content";
  public static final String IF_INVOLVE ="if_involve";
  public static final String CONTENT ="content";
  public static final String SORT_NO ="sort_no";


}
