package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 日常管理-每日工作计划-检查结果-隐患关联对象 t_contractor_daily_plan_inspect_result_hazard
 * 
 * @author testor-framework
 * @date 2024-11-30 15:43:18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_daily_plan_inspect_result_hazard")
@ApiModel(value = "TContractorDailyPlanInspectResultHazard对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorDailyPlanInspectResultHazard extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 检查任务id
 */
  @ApiModelProperty(value = "检查任务id")

  @TableField("inspect_id")
  private String inspectId;
/**
 * 检查结果id
 */
  @ApiModelProperty(value = "检查结果id")

  @TableField("inspect_result_id")
  private String inspectResultId;
/**
 * 计划id
 */
  @ApiModelProperty(value = "计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 隐患id
 */
  @ApiModelProperty(value = "隐患id")

  @TableField("hazard_id")
  private String hazardId;

  public static final String ID ="id";
  public static final String INSPECT_ID ="inspect_id";
  public static final String INSPECT_RESULT_ID ="inspect_result_id";
  public static final String PLAN_ID ="plan_id";
  public static final String HAZARD_ID ="hazard_id";


}
